/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WaypointOptimizationHazardousCargoType {
    COMBUSTIBLE("Combustible"),
    CORROSIVE("Corrosive"),
    EXPLOSIVE("Explosive"),
    FLAMMABLE("Flammable"),
    GAS("Gas"),
    HARMFUL_TO_WATER("HarmfulToWater"),
    ORGANIC("Organic"),
    OTHER("Other"),
    POISON("Poison"),
    POISONOUS_INHALATION("PoisonousInhalation"),
    RADIOACTIVE("Radioactive"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WaypointOptimizationHazardousCargoType> VALUE_MAP;
    private final String value;

    private WaypointOptimizationHazardousCargoType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WaypointOptimizationHazardousCargoType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WaypointOptimizationHazardousCargoType> knownValues() {
        EnumSet<WaypointOptimizationHazardousCargoType> knownValues = EnumSet.allOf(WaypointOptimizationHazardousCargoType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WaypointOptimizationHazardousCargoType.class, WaypointOptimizationHazardousCargoType::toString);
    }
}

