/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GeometryFormat {
    FLEXIBLE_POLYLINE("FlexiblePolyline"),
    SIMPLE("Simple"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GeometryFormat> VALUE_MAP;
    private final String value;

    private GeometryFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GeometryFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GeometryFormat> knownValues() {
        EnumSet<GeometryFormat> knownValues = EnumSet.allOf(GeometryFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GeometryFormat.class, GeometryFormat::toString);
    }
}

