/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteMatrixEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteMatrixEntry> {
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(RouteMatrixEntry.getter(RouteMatrixEntry::distance)).setter(RouteMatrixEntry.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(RouteMatrixEntry.getter(RouteMatrixEntry::duration)).setter(RouteMatrixEntry.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(RouteMatrixEntry.getter(RouteMatrixEntry::errorAsString)).setter(RouteMatrixEntry.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTANCE_FIELD, DURATION_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteMatrixEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long distance;
    private final Long duration;
    private final String error;

    private RouteMatrixEntry(BuilderImpl builder) {
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.error = builder.error;
    }

    public final Long distance() {
        return this.distance;
    }

    public final Long duration() {
        return this.duration;
    }

    public final RouteMatrixErrorCode error() {
        return RouteMatrixErrorCode.fromValue(this.error);
    }

    public final String errorAsString() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixEntry)) {
            return false;
        }
        RouteMatrixEntry other = (RouteMatrixEntry)obj;
        return Objects.equals(this.distance(), other.distance()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.errorAsString(), other.errorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteMatrixEntry").add("Distance", (Object)this.distance()).add("Duration", (Object)this.duration()).add("Error", (Object)this.errorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.errorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixEntry, T> g) {
        return obj -> g.apply((RouteMatrixEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long distance;
        private Long duration;
        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixEntry model) {
            this.distance(model.distance);
            this.duration(model.duration);
            this.error(model.error);
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(RouteMatrixErrorCode error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public RouteMatrixEntry build() {
            return new RouteMatrixEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteMatrixEntry> {
        public Builder distance(Long var1);

        public Builder duration(Long var1);

        public Builder error(String var1);

        public Builder error(RouteMatrixErrorCode var1);
    }
}

