/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteHazardousCargoType {
    COMBUSTIBLE("Combustible"),
    CORROSIVE("Corrosive"),
    EXPLOSIVE("Explosive"),
    FLAMMABLE("Flammable"),
    GAS("Gas"),
    HARMFUL_TO_WATER("HarmfulToWater"),
    ORGANIC("Organic"),
    OTHER("Other"),
    POISON("Poison"),
    POISONOUS_INHALATION("PoisonousInhalation"),
    RADIOACTIVE("Radioactive"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteHazardousCargoType> VALUE_MAP;
    private final String value;

    private RouteHazardousCargoType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteHazardousCargoType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteHazardousCargoType> knownValues() {
        EnumSet<RouteHazardousCargoType> knownValues = EnumSet.allOf(RouteHazardousCargoType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteHazardousCargoType.class, RouteHazardousCargoType::toString);
    }
}

