/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PlaceType {
    COUNTRY("Country"),
    REGION("Region"),
    SUB_REGION("SubRegion"),
    LOCALITY("Locality"),
    DISTRICT("District"),
    SUB_DISTRICT("SubDistrict"),
    POSTAL_CODE("PostalCode"),
    BLOCK("Block"),
    SUB_BLOCK("SubBlock"),
    INTERSECTION("Intersection"),
    STREET("Street"),
    POINT_OF_INTEREST("PointOfInterest"),
    POINT_ADDRESS("PointAddress"),
    INTERPOLATED_ADDRESS("InterpolatedAddress"),
    SECONDARY_ADDRESS("SecondaryAddress"),
    INFERRED_SECONDARY_ADDRESS("InferredSecondaryAddress"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PlaceType> VALUE_MAP;
    private final String value;

    private PlaceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlaceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlaceType> knownValues() {
        EnumSet<PlaceType> knownValues = EnumSet.allOf(PlaceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PlaceType.class, PlaceType::toString);
    }
}

