/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.AccessPoint;
import software.amazon.awssdk.services.geoplaces.model.AccessPointListCopier;
import software.amazon.awssdk.services.geoplaces.model.Address;
import software.amazon.awssdk.services.geoplaces.model.BoundingBoxCopier;
import software.amazon.awssdk.services.geoplaces.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Intersection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Intersection> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceId").getter(Intersection.getter(Intersection::placeId)).setter(Intersection.setter(Builder::placeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Intersection.getter(Intersection::title)).setter(Intersection.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(Intersection.getter(Intersection::address)).setter(Intersection.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(Intersection.getter(Intersection::position)).setter(Intersection.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(Intersection.getter(Intersection::distance)).setter(Intersection.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Long> ROUTE_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RouteDistance").getter(Intersection.getter(Intersection::routeDistance)).setter(Intersection.setter(Builder::routeDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteDistance").build()}).build();
    private static final SdkField<List<Double>> MAP_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MapView").getter(Intersection.getter(Intersection::mapView)).setter(Intersection.setter(Builder::mapView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapView").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AccessPoint>> ACCESS_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessPoints").getter(Intersection.getter(Intersection::accessPoints)).setter(Intersection.setter(Builder::accessPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_ID_FIELD, TITLE_FIELD, ADDRESS_FIELD, POSITION_FIELD, DISTANCE_FIELD, ROUTE_DISTANCE_FIELD, MAP_VIEW_FIELD, ACCESS_POINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Intersection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String placeId;
    private final String title;
    private final Address address;
    private final List<Double> position;
    private final Long distance;
    private final Long routeDistance;
    private final List<Double> mapView;
    private final List<AccessPoint> accessPoints;

    private Intersection(BuilderImpl builder) {
        this.placeId = builder.placeId;
        this.title = builder.title;
        this.address = builder.address;
        this.position = builder.position;
        this.distance = builder.distance;
        this.routeDistance = builder.routeDistance;
        this.mapView = builder.mapView;
        this.accessPoints = builder.accessPoints;
    }

    public final String placeId() {
        return this.placeId;
    }

    public final String title() {
        return this.title;
    }

    public final Address address() {
        return this.address;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final Long distance() {
        return this.distance;
    }

    public final Long routeDistance() {
        return this.routeDistance;
    }

    public final boolean hasMapView() {
        return this.mapView != null && !(this.mapView instanceof SdkAutoConstructList);
    }

    public final List<Double> mapView() {
        return this.mapView;
    }

    public final boolean hasAccessPoints() {
        return this.accessPoints != null && !(this.accessPoints instanceof SdkAutoConstructList);
    }

    public final List<AccessPoint> accessPoints() {
        return this.accessPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeDistance());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapView() ? this.mapView() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessPoints() ? this.accessPoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Intersection)) {
            return false;
        }
        Intersection other = (Intersection)obj;
        return Objects.equals(this.placeId(), other.placeId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.address(), other.address()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.routeDistance(), other.routeDistance()) && this.hasMapView() == other.hasMapView() && Objects.equals(this.mapView(), other.mapView()) && this.hasAccessPoints() == other.hasAccessPoints() && Objects.equals(this.accessPoints(), other.accessPoints());
    }

    public final String toString() {
        return ToString.builder((String)"Intersection").add("PlaceId", (Object)(this.placeId() == null ? null : "*** Sensitive Data Redacted ***")).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("Address", (Object)this.address()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("Distance", (Object)(this.distance() == null ? null : "*** Sensitive Data Redacted ***")).add("RouteDistance", (Object)(this.routeDistance() == null ? null : "*** Sensitive Data Redacted ***")).add("MapView", (Object)(this.mapView() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessPoints", this.hasAccessPoints() ? this.accessPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlaceId": {
                return Optional.ofNullable(clazz.cast(this.placeId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "RouteDistance": {
                return Optional.ofNullable(clazz.cast(this.routeDistance()));
            }
            case "MapView": {
                return Optional.ofNullable(clazz.cast(this.mapView()));
            }
            case "AccessPoints": {
                return Optional.ofNullable(clazz.cast(this.accessPoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PlaceId", PLACE_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("RouteDistance", ROUTE_DISTANCE_FIELD);
        map.put("MapView", MAP_VIEW_FIELD);
        map.put("AccessPoints", ACCESS_POINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Intersection, T> g) {
        return obj -> g.apply((Intersection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String placeId;
        private String title;
        private Address address;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private Long distance;
        private Long routeDistance;
        private List<Double> mapView = DefaultSdkAutoConstructList.getInstance();
        private List<AccessPoint> accessPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Intersection model) {
            this.placeId(model.placeId);
            this.title(model.title);
            this.address(model.address);
            this.position(model.position);
            this.distance(model.distance);
            this.routeDistance(model.routeDistance);
            this.mapView(model.mapView);
            this.accessPoints(model.accessPoints);
        }

        public final String getPlaceId() {
            return this.placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getRouteDistance() {
            return this.routeDistance;
        }

        public final void setRouteDistance(Long routeDistance) {
            this.routeDistance = routeDistance;
        }

        @Override
        public final Builder routeDistance(Long routeDistance) {
            this.routeDistance = routeDistance;
            return this;
        }

        public final Collection<Double> getMapView() {
            if (this.mapView instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mapView;
        }

        public final void setMapView(Collection<Double> mapView) {
            this.mapView = BoundingBoxCopier.copy(mapView);
        }

        @Override
        public final Builder mapView(Collection<Double> mapView) {
            this.mapView = BoundingBoxCopier.copy(mapView);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapView(Double ... mapView) {
            this.mapView(Arrays.asList(mapView));
            return this;
        }

        public final List<AccessPoint.Builder> getAccessPoints() {
            List<AccessPoint.Builder> result = AccessPointListCopier.copyToBuilder(this.accessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPoints(Collection<AccessPoint.BuilderImpl> accessPoints) {
            this.accessPoints = AccessPointListCopier.copyFromBuilder(accessPoints);
        }

        @Override
        public final Builder accessPoints(Collection<AccessPoint> accessPoints) {
            this.accessPoints = AccessPointListCopier.copy(accessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(AccessPoint ... accessPoints) {
            this.accessPoints(Arrays.asList(accessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(Consumer<AccessPoint.Builder> ... accessPoints) {
            this.accessPoints(Stream.of(accessPoints).map(c -> (AccessPoint)((AccessPoint.Builder)AccessPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Intersection build() {
            return new Intersection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Intersection> {
        public Builder placeId(String var1);

        public Builder title(String var1);

        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder distance(Long var1);

        public Builder routeDistance(Long var1);

        public Builder mapView(Collection<Double> var1);

        public Builder mapView(Double ... var1);

        public Builder accessPoints(Collection<AccessPoint> var1);

        public Builder accessPoints(AccessPoint ... var1);

        public Builder accessPoints(Consumer<AccessPoint.Builder> ... var1);
    }
}

