/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.gameliftstreams.model.FilePathsCopier;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.RuntimeEnvironment;
import software.amazon.awssdk.services.gameliftstreams.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends GameLiftStreamsRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateApplicationRequest.getter(CreateApplicationRequest::description)).setter(CreateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<RuntimeEnvironment> RUNTIME_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeEnvironment").getter(CreateApplicationRequest.getter(CreateApplicationRequest::runtimeEnvironment)).setter(CreateApplicationRequest.setter(Builder::runtimeEnvironment)).constructor(RuntimeEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build()}).build();
    private static final SdkField<String> EXECUTABLE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutablePath").getter(CreateApplicationRequest.getter(CreateApplicationRequest::executablePath)).setter(CreateApplicationRequest.setter(Builder::executablePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutablePath").build()}).build();
    private static final SdkField<String> APPLICATION_SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationSourceUri").getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationSourceUri)).setter(CreateApplicationRequest.setter(Builder::applicationSourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSourceUri").build()}).build();
    private static final SdkField<List<String>> APPLICATION_LOG_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationLogPaths").getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationLogPaths)).setter(CreateApplicationRequest.setter(Builder::applicationLogPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_LOG_OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationLogOutputUri").getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationLogOutputUri)).setter(CreateApplicationRequest.setter(Builder::applicationLogOutputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogOutputUri").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateApplicationRequest.getter(CreateApplicationRequest::tags)).setter(CreateApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateApplicationRequest.getter(CreateApplicationRequest::clientToken)).setter(CreateApplicationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, RUNTIME_ENVIRONMENT_FIELD, EXECUTABLE_PATH_FIELD, APPLICATION_SOURCE_URI_FIELD, APPLICATION_LOG_PATHS_FIELD, APPLICATION_LOG_OUTPUT_URI_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApplicationRequest.memberNameToFieldInitializer();
    private final String description;
    private final RuntimeEnvironment runtimeEnvironment;
    private final String executablePath;
    private final String applicationSourceUri;
    private final List<String> applicationLogPaths;
    private final String applicationLogOutputUri;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.executablePath = builder.executablePath;
        this.applicationSourceUri = builder.applicationSourceUri;
        this.applicationLogPaths = builder.applicationLogPaths;
        this.applicationLogOutputUri = builder.applicationLogOutputUri;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final RuntimeEnvironment runtimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public final String executablePath() {
        return this.executablePath;
    }

    public final String applicationSourceUri() {
        return this.applicationSourceUri;
    }

    public final boolean hasApplicationLogPaths() {
        return this.applicationLogPaths != null && !(this.applicationLogPaths instanceof SdkAutoConstructList);
    }

    public final List<String> applicationLogPaths() {
        return this.applicationLogPaths;
    }

    public final String applicationLogOutputUri() {
        return this.applicationLogOutputUri;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(this.executablePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationLogPaths() ? this.applicationLogPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationLogOutputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.runtimeEnvironment(), other.runtimeEnvironment()) && Objects.equals(this.executablePath(), other.executablePath()) && Objects.equals(this.applicationSourceUri(), other.applicationSourceUri()) && this.hasApplicationLogPaths() == other.hasApplicationLogPaths() && Objects.equals(this.applicationLogPaths(), other.applicationLogPaths()) && Objects.equals(this.applicationLogOutputUri(), other.applicationLogOutputUri()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("Description", (Object)this.description()).add("RuntimeEnvironment", (Object)this.runtimeEnvironment()).add("ExecutablePath", (Object)this.executablePath()).add("ApplicationSourceUri", (Object)this.applicationSourceUri()).add("ApplicationLogPaths", this.hasApplicationLogPaths() ? this.applicationLogPaths() : null).add("ApplicationLogOutputUri", (Object)this.applicationLogOutputUri()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RuntimeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironment()));
            }
            case "ExecutablePath": {
                return Optional.ofNullable(clazz.cast(this.executablePath()));
            }
            case "ApplicationSourceUri": {
                return Optional.ofNullable(clazz.cast(this.applicationSourceUri()));
            }
            case "ApplicationLogPaths": {
                return Optional.ofNullable(clazz.cast(this.applicationLogPaths()));
            }
            case "ApplicationLogOutputUri": {
                return Optional.ofNullable(clazz.cast(this.applicationLogOutputUri()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuntimeEnvironment", RUNTIME_ENVIRONMENT_FIELD);
        map.put("ExecutablePath", EXECUTABLE_PATH_FIELD);
        map.put("ApplicationSourceUri", APPLICATION_SOURCE_URI_FIELD);
        map.put("ApplicationLogPaths", APPLICATION_LOG_PATHS_FIELD);
        map.put("ApplicationLogOutputUri", APPLICATION_LOG_OUTPUT_URI_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsRequest.BuilderImpl
    implements Builder {
        private String description;
        private RuntimeEnvironment runtimeEnvironment;
        private String executablePath;
        private String applicationSourceUri;
        private List<String> applicationLogPaths = DefaultSdkAutoConstructList.getInstance();
        private String applicationLogOutputUri;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.description(model.description);
            this.runtimeEnvironment(model.runtimeEnvironment);
            this.executablePath(model.executablePath);
            this.applicationSourceUri(model.applicationSourceUri);
            this.applicationLogPaths(model.applicationLogPaths);
            this.applicationLogOutputUri(model.applicationLogOutputUri);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RuntimeEnvironment.Builder getRuntimeEnvironment() {
            return this.runtimeEnvironment != null ? this.runtimeEnvironment.toBuilder() : null;
        }

        public final void setRuntimeEnvironment(RuntimeEnvironment.BuilderImpl runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment != null ? runtimeEnvironment.build() : null;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        public final String getExecutablePath() {
            return this.executablePath;
        }

        public final void setExecutablePath(String executablePath) {
            this.executablePath = executablePath;
        }

        @Override
        public final Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public final String getApplicationSourceUri() {
            return this.applicationSourceUri;
        }

        public final void setApplicationSourceUri(String applicationSourceUri) {
            this.applicationSourceUri = applicationSourceUri;
        }

        @Override
        public final Builder applicationSourceUri(String applicationSourceUri) {
            this.applicationSourceUri = applicationSourceUri;
            return this;
        }

        public final Collection<String> getApplicationLogPaths() {
            if (this.applicationLogPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationLogPaths;
        }

        public final void setApplicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
        }

        @Override
        public final Builder applicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationLogPaths(String ... applicationLogPaths) {
            this.applicationLogPaths(Arrays.asList(applicationLogPaths));
            return this;
        }

        public final String getApplicationLogOutputUri() {
            return this.applicationLogOutputUri;
        }

        public final void setApplicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
        }

        @Override
        public final Builder applicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder description(String var1);

        public Builder runtimeEnvironment(RuntimeEnvironment var1);

        default public Builder runtimeEnvironment(Consumer<RuntimeEnvironment.Builder> runtimeEnvironment) {
            return this.runtimeEnvironment((RuntimeEnvironment)((RuntimeEnvironment.Builder)RuntimeEnvironment.builder().applyMutation(runtimeEnvironment)).build());
        }

        public Builder executablePath(String var1);

        public Builder applicationSourceUri(String var1);

        public Builder applicationLogPaths(Collection<String> var1);

        public Builder applicationLogPaths(String ... var1);

        public Builder applicationLogOutputUri(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

