/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.ContainerMountPointAccessLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerMountPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerMountPoint> {
    private static final SdkField<String> INSTANCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstancePath").getter(ContainerMountPoint.getter(ContainerMountPoint::instancePath)).setter(ContainerMountPoint.setter(Builder::instancePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePath").build()}).build();
    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerPath").getter(ContainerMountPoint.getter(ContainerMountPoint::containerPath)).setter(ContainerMountPoint.setter(Builder::containerPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPath").build()}).build();
    private static final SdkField<String> ACCESS_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessLevel").getter(ContainerMountPoint.getter(ContainerMountPoint::accessLevelAsString)).setter(ContainerMountPoint.setter(Builder::accessLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PATH_FIELD, CONTAINER_PATH_FIELD, ACCESS_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerMountPoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instancePath;
    private final String containerPath;
    private final String accessLevel;

    private ContainerMountPoint(BuilderImpl builder) {
        this.instancePath = builder.instancePath;
        this.containerPath = builder.containerPath;
        this.accessLevel = builder.accessLevel;
    }

    public final String instancePath() {
        return this.instancePath;
    }

    public final String containerPath() {
        return this.containerPath;
    }

    public final ContainerMountPointAccessLevel accessLevel() {
        return ContainerMountPointAccessLevel.fromValue(this.accessLevel);
    }

    public final String accessLevelAsString() {
        return this.accessLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerMountPoint)) {
            return false;
        }
        ContainerMountPoint other = (ContainerMountPoint)obj;
        return Objects.equals(this.instancePath(), other.instancePath()) && Objects.equals(this.containerPath(), other.containerPath()) && Objects.equals(this.accessLevelAsString(), other.accessLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerMountPoint").add("InstancePath", (Object)this.instancePath()).add("ContainerPath", (Object)this.containerPath()).add("AccessLevel", (Object)this.accessLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstancePath": {
                return Optional.ofNullable(clazz.cast(this.instancePath()));
            }
            case "ContainerPath": {
                return Optional.ofNullable(clazz.cast(this.containerPath()));
            }
            case "AccessLevel": {
                return Optional.ofNullable(clazz.cast(this.accessLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstancePath", INSTANCE_PATH_FIELD);
        map.put("ContainerPath", CONTAINER_PATH_FIELD);
        map.put("AccessLevel", ACCESS_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerMountPoint, T> g) {
        return obj -> g.apply((ContainerMountPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instancePath;
        private String containerPath;
        private String accessLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerMountPoint model) {
            this.instancePath(model.instancePath);
            this.containerPath(model.containerPath);
            this.accessLevel(model.accessLevel);
        }

        public final String getInstancePath() {
            return this.instancePath;
        }

        public final void setInstancePath(String instancePath) {
            this.instancePath = instancePath;
        }

        @Override
        public final Builder instancePath(String instancePath) {
            this.instancePath = instancePath;
            return this;
        }

        public final String getContainerPath() {
            return this.containerPath;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final String getAccessLevel() {
            return this.accessLevel;
        }

        public final void setAccessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
        }

        @Override
        public final Builder accessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        @Override
        public final Builder accessLevel(ContainerMountPointAccessLevel accessLevel) {
            this.accessLevel(accessLevel == null ? null : accessLevel.toString());
            return this;
        }

        public ContainerMountPoint build() {
            return new ContainerMountPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerMountPoint> {
        public Builder instancePath(String var1);

        public Builder containerPath(String var1);

        public Builder accessLevel(String var1);

        public Builder accessLevel(ContainerMountPointAccessLevel var1);
    }
}

