/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FleetDeployment;
import software.amazon.awssdk.services.gamelift.model.FleetDeploymentsCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFleetDeploymentsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListFleetDeploymentsResponse> {
    private static final SdkField<List<FleetDeployment>> FLEET_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FleetDeployments").getter(ListFleetDeploymentsResponse.getter(ListFleetDeploymentsResponse::fleetDeployments)).setter(ListFleetDeploymentsResponse.setter(Builder::fleetDeployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetDeployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFleetDeploymentsResponse.getter(ListFleetDeploymentsResponse::nextToken)).setter(ListFleetDeploymentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_DEPLOYMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFleetDeploymentsResponse.memberNameToFieldInitializer();
    private final List<FleetDeployment> fleetDeployments;
    private final String nextToken;

    private ListFleetDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetDeployments = builder.fleetDeployments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFleetDeployments() {
        return this.fleetDeployments != null && !(this.fleetDeployments instanceof SdkAutoConstructList);
    }

    public final List<FleetDeployment> fleetDeployments() {
        return this.fleetDeployments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetDeployments() ? this.fleetDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetDeploymentsResponse)) {
            return false;
        }
        ListFleetDeploymentsResponse other = (ListFleetDeploymentsResponse)((Object)obj);
        return this.hasFleetDeployments() == other.hasFleetDeployments() && Objects.equals(this.fleetDeployments(), other.fleetDeployments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFleetDeploymentsResponse").add("FleetDeployments", this.hasFleetDeployments() ? this.fleetDeployments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetDeployments": {
                return Optional.ofNullable(clazz.cast(this.fleetDeployments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FleetDeployments", FLEET_DEPLOYMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFleetDeploymentsResponse, T> g) {
        return obj -> g.apply((ListFleetDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<FleetDeployment> fleetDeployments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetDeploymentsResponse model) {
            super(model);
            this.fleetDeployments(model.fleetDeployments);
            this.nextToken(model.nextToken);
        }

        public final List<FleetDeployment.Builder> getFleetDeployments() {
            List<FleetDeployment.Builder> result = FleetDeploymentsCopier.copyToBuilder(this.fleetDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetDeployments(Collection<FleetDeployment.BuilderImpl> fleetDeployments) {
            this.fleetDeployments = FleetDeploymentsCopier.copyFromBuilder(fleetDeployments);
        }

        @Override
        public final Builder fleetDeployments(Collection<FleetDeployment> fleetDeployments) {
            this.fleetDeployments = FleetDeploymentsCopier.copy(fleetDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetDeployments(FleetDeployment ... fleetDeployments) {
            this.fleetDeployments(Arrays.asList(fleetDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetDeployments(Consumer<FleetDeployment.Builder> ... fleetDeployments) {
            this.fleetDeployments(Stream.of(fleetDeployments).map(c -> (FleetDeployment)((FleetDeployment.Builder)FleetDeployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFleetDeploymentsResponse build() {
            return new ListFleetDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFleetDeploymentsResponse> {
        public Builder fleetDeployments(Collection<FleetDeployment> var1);

        public Builder fleetDeployments(FleetDeployment ... var1);

        public Builder fleetDeployments(Consumer<FleetDeployment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

