/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinition;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionVersionsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionVersionsResponse;

public class ListContainerGroupDefinitionVersionsIterable
implements SdkIterable<ListContainerGroupDefinitionVersionsResponse> {
    private final GameLiftClient client;
    private final ListContainerGroupDefinitionVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContainerGroupDefinitionVersionsIterable(GameLiftClient client, ListContainerGroupDefinitionVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContainerGroupDefinitionVersionsResponseFetcher();
    }

    public Iterator<ListContainerGroupDefinitionVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContainerGroupDefinition> containerGroupDefinitions() {
        Function<ListContainerGroupDefinitionVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.containerGroupDefinitions() != null) {
                return response.containerGroupDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContainerGroupDefinitionVersionsResponseFetcher
    implements SyncPageFetcher<ListContainerGroupDefinitionVersionsResponse> {
        private ListContainerGroupDefinitionVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerGroupDefinitionVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContainerGroupDefinitionVersionsResponse nextPage(ListContainerGroupDefinitionVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListContainerGroupDefinitionVersionsIterable.this.client.listContainerGroupDefinitionVersions(ListContainerGroupDefinitionVersionsIterable.this.firstRequest);
            }
            return ListContainerGroupDefinitionVersionsIterable.this.client.listContainerGroupDefinitionVersions((ListContainerGroupDefinitionVersionsRequest)((Object)ListContainerGroupDefinitionVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

