/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.ContainerFleet;
import software.amazon.awssdk.services.gamelift.model.ListContainerFleetsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerFleetsResponse;

public class ListContainerFleetsIterable
implements SdkIterable<ListContainerFleetsResponse> {
    private final GameLiftClient client;
    private final ListContainerFleetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContainerFleetsIterable(GameLiftClient client, ListContainerFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContainerFleetsResponseFetcher();
    }

    public Iterator<ListContainerFleetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContainerFleet> containerFleets() {
        Function<ListContainerFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.containerFleets() != null) {
                return response.containerFleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContainerFleetsResponseFetcher
    implements SyncPageFetcher<ListContainerFleetsResponse> {
        private ListContainerFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContainerFleetsResponse nextPage(ListContainerFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListContainerFleetsIterable.this.client.listContainerFleets(ListContainerFleetsIterable.this.firstRequest);
            }
            return ListContainerFleetsIterable.this.client.listContainerFleets((ListContainerFleetsRequest)((Object)ListContainerFleetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

