/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueue;

public class DescribeGameSessionQueuesIterable
implements SdkIterable<DescribeGameSessionQueuesResponse> {
    private final GameLiftClient client;
    private final DescribeGameSessionQueuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeGameSessionQueuesIterable(GameLiftClient client, DescribeGameSessionQueuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeGameSessionQueuesResponseFetcher();
    }

    public Iterator<DescribeGameSessionQueuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GameSessionQueue> gameSessionQueues() {
        Function<DescribeGameSessionQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameSessionQueues() != null) {
                return response.gameSessionQueues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeGameSessionQueuesResponseFetcher
    implements SyncPageFetcher<DescribeGameSessionQueuesResponse> {
        private DescribeGameSessionQueuesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGameSessionQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeGameSessionQueuesResponse nextPage(DescribeGameSessionQueuesResponse previousPage) {
            if (previousPage == null) {
                return DescribeGameSessionQueuesIterable.this.client.describeGameSessionQueues(DescribeGameSessionQueuesIterable.this.firstRequest);
            }
            return DescribeGameSessionQueuesIterable.this.client.describeGameSessionQueues((DescribeGameSessionQueuesRequest)((Object)DescribeGameSessionQueuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

