/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LogDestination {
    NONE("NONE"),
    CLOUDWATCH("CLOUDWATCH"),
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LogDestination> VALUE_MAP;
    private final String value;

    private LogDestination(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogDestination fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogDestination> knownValues() {
        EnumSet<LogDestination> knownValues = EnumSet.allOf(LogDestination.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LogDestination.class, LogDestination::toString);
    }
}

