/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ConnectionPortRange;
import software.amazon.awssdk.services.gamelift.model.ContainerFleetRemoveAttribute;
import software.amazon.awssdk.services.gamelift.model.ContainerFleetRemoveAttributeListCopier;
import software.amazon.awssdk.services.gamelift.model.DeploymentConfiguration;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameSessionCreationLimitPolicy;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.services.gamelift.model.LogConfiguration;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContainerFleetRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateContainerFleetRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::fleetId)).setter(UpdateContainerFleetRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerContainerGroupDefinitionName").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::gameServerContainerGroupDefinitionName)).setter(UpdateContainerFleetRequest.setter(Builder::gameServerContainerGroupDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerGroupDefinitionName").build()}).build();
    private static final SdkField<String> PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerInstanceContainerGroupDefinitionName").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::perInstanceContainerGroupDefinitionName)).setter(UpdateContainerFleetRequest.setter(Builder::perInstanceContainerGroupDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerInstanceContainerGroupDefinitionName").build()}).build();
    private static final SdkField<Integer> GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GameServerContainerGroupsPerInstance").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::gameServerContainerGroupsPerInstance)).setter(UpdateContainerFleetRequest.setter(Builder::gameServerContainerGroupsPerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerGroupsPerInstance").build()}).build();
    private static final SdkField<ConnectionPortRange> INSTANCE_CONNECTION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceConnectionPortRange").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::instanceConnectionPortRange)).setter(UpdateContainerFleetRequest.setter(Builder::instanceConnectionPortRange)).constructor(ConnectionPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectionPortRange").build()}).build();
    private static final SdkField<List<IpPermission>> INSTANCE_INBOUND_PERMISSION_AUTHORIZATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceInboundPermissionAuthorizations").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::instanceInboundPermissionAuthorizations)).setter(UpdateContainerFleetRequest.setter(Builder::instanceInboundPermissionAuthorizations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInboundPermissionAuthorizations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<IpPermission>> INSTANCE_INBOUND_PERMISSION_REVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceInboundPermissionRevocations").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::instanceInboundPermissionRevocations)).setter(UpdateContainerFleetRequest.setter(Builder::instanceInboundPermissionRevocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInboundPermissionRevocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentConfiguration").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::deploymentConfiguration)).setter(UpdateContainerFleetRequest.setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::description)).setter(UpdateContainerFleetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricGroups").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::metricGroups)).setter(UpdateContainerFleetRequest.setter(Builder::metricGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewGameSessionProtectionPolicy").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::newGameSessionProtectionPolicyAsString)).setter(UpdateContainerFleetRequest.setter(Builder::newGameSessionProtectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy").build()}).build();
    private static final SdkField<GameSessionCreationLimitPolicy> GAME_SESSION_CREATION_LIMIT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GameSessionCreationLimitPolicy").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::gameSessionCreationLimitPolicy)).setter(UpdateContainerFleetRequest.setter(Builder::gameSessionCreationLimitPolicy)).constructor(GameSessionCreationLimitPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionCreationLimitPolicy").build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfiguration").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::logConfiguration)).setter(UpdateContainerFleetRequest.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()}).build();
    private static final SdkField<List<String>> REMOVE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveAttributes").getter(UpdateContainerFleetRequest.getter(UpdateContainerFleetRequest::removeAttributesAsStrings)).setter(UpdateContainerFleetRequest.setter(Builder::removeAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD, PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD, GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD, INSTANCE_CONNECTION_PORT_RANGE_FIELD, INSTANCE_INBOUND_PERMISSION_AUTHORIZATIONS_FIELD, INSTANCE_INBOUND_PERMISSION_REVOCATIONS_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, DESCRIPTION_FIELD, METRIC_GROUPS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD, GAME_SESSION_CREATION_LIMIT_POLICY_FIELD, LOG_CONFIGURATION_FIELD, REMOVE_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateContainerFleetRequest.memberNameToFieldInitializer();
    private final String fleetId;
    private final String gameServerContainerGroupDefinitionName;
    private final String perInstanceContainerGroupDefinitionName;
    private final Integer gameServerContainerGroupsPerInstance;
    private final ConnectionPortRange instanceConnectionPortRange;
    private final List<IpPermission> instanceInboundPermissionAuthorizations;
    private final List<IpPermission> instanceInboundPermissionRevocations;
    private final DeploymentConfiguration deploymentConfiguration;
    private final String description;
    private final List<String> metricGroups;
    private final String newGameSessionProtectionPolicy;
    private final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;
    private final LogConfiguration logConfiguration;
    private final List<String> removeAttributes;

    private UpdateContainerFleetRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.gameServerContainerGroupDefinitionName = builder.gameServerContainerGroupDefinitionName;
        this.perInstanceContainerGroupDefinitionName = builder.perInstanceContainerGroupDefinitionName;
        this.gameServerContainerGroupsPerInstance = builder.gameServerContainerGroupsPerInstance;
        this.instanceConnectionPortRange = builder.instanceConnectionPortRange;
        this.instanceInboundPermissionAuthorizations = builder.instanceInboundPermissionAuthorizations;
        this.instanceInboundPermissionRevocations = builder.instanceInboundPermissionRevocations;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.description = builder.description;
        this.metricGroups = builder.metricGroups;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.gameSessionCreationLimitPolicy = builder.gameSessionCreationLimitPolicy;
        this.logConfiguration = builder.logConfiguration;
        this.removeAttributes = builder.removeAttributes;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String gameServerContainerGroupDefinitionName() {
        return this.gameServerContainerGroupDefinitionName;
    }

    public final String perInstanceContainerGroupDefinitionName() {
        return this.perInstanceContainerGroupDefinitionName;
    }

    public final Integer gameServerContainerGroupsPerInstance() {
        return this.gameServerContainerGroupsPerInstance;
    }

    public final ConnectionPortRange instanceConnectionPortRange() {
        return this.instanceConnectionPortRange;
    }

    public final boolean hasInstanceInboundPermissionAuthorizations() {
        return this.instanceInboundPermissionAuthorizations != null && !(this.instanceInboundPermissionAuthorizations instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> instanceInboundPermissionAuthorizations() {
        return this.instanceInboundPermissionAuthorizations;
    }

    public final boolean hasInstanceInboundPermissionRevocations() {
        return this.instanceInboundPermissionRevocations != null && !(this.instanceInboundPermissionRevocations instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> instanceInboundPermissionRevocations() {
        return this.instanceInboundPermissionRevocations;
    }

    public final DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMetricGroups() {
        return this.metricGroups != null && !(this.metricGroups instanceof SdkAutoConstructList);
    }

    public final List<String> metricGroups() {
        return this.metricGroups;
    }

    public final ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(this.newGameSessionProtectionPolicy);
    }

    public final String newGameSessionProtectionPolicyAsString() {
        return this.newGameSessionProtectionPolicy;
    }

    public final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy() {
        return this.gameSessionCreationLimitPolicy;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final List<ContainerFleetRemoveAttribute> removeAttributes() {
        return ContainerFleetRemoveAttributeListCopier.copyStringToEnum(this.removeAttributes);
    }

    public final boolean hasRemoveAttributes() {
        return this.removeAttributes != null && !(this.removeAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> removeAttributesAsStrings() {
        return this.removeAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.perInstanceContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerContainerGroupsPerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConnectionPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceInboundPermissionAuthorizations() ? this.instanceInboundPermissionAuthorizations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceInboundPermissionRevocations() ? this.instanceInboundPermissionRevocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricGroups() ? this.metricGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveAttributes() ? this.removeAttributesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerFleetRequest)) {
            return false;
        }
        UpdateContainerFleetRequest other = (UpdateContainerFleetRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.gameServerContainerGroupDefinitionName(), other.gameServerContainerGroupDefinitionName()) && Objects.equals(this.perInstanceContainerGroupDefinitionName(), other.perInstanceContainerGroupDefinitionName()) && Objects.equals(this.gameServerContainerGroupsPerInstance(), other.gameServerContainerGroupsPerInstance()) && Objects.equals(this.instanceConnectionPortRange(), other.instanceConnectionPortRange()) && this.hasInstanceInboundPermissionAuthorizations() == other.hasInstanceInboundPermissionAuthorizations() && Objects.equals(this.instanceInboundPermissionAuthorizations(), other.instanceInboundPermissionAuthorizations()) && this.hasInstanceInboundPermissionRevocations() == other.hasInstanceInboundPermissionRevocations() && Objects.equals(this.instanceInboundPermissionRevocations(), other.instanceInboundPermissionRevocations()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration()) && Objects.equals(this.description(), other.description()) && this.hasMetricGroups() == other.hasMetricGroups() && Objects.equals(this.metricGroups(), other.metricGroups()) && Objects.equals(this.newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString()) && Objects.equals(this.gameSessionCreationLimitPolicy(), other.gameSessionCreationLimitPolicy()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && this.hasRemoveAttributes() == other.hasRemoveAttributes() && Objects.equals(this.removeAttributesAsStrings(), other.removeAttributesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContainerFleetRequest").add("FleetId", (Object)this.fleetId()).add("GameServerContainerGroupDefinitionName", (Object)this.gameServerContainerGroupDefinitionName()).add("PerInstanceContainerGroupDefinitionName", (Object)this.perInstanceContainerGroupDefinitionName()).add("GameServerContainerGroupsPerInstance", (Object)this.gameServerContainerGroupsPerInstance()).add("InstanceConnectionPortRange", (Object)this.instanceConnectionPortRange()).add("InstanceInboundPermissionAuthorizations", this.hasInstanceInboundPermissionAuthorizations() ? this.instanceInboundPermissionAuthorizations() : null).add("InstanceInboundPermissionRevocations", this.hasInstanceInboundPermissionRevocations() ? this.instanceInboundPermissionRevocations() : null).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).add("Description", (Object)this.description()).add("MetricGroups", this.hasMetricGroups() ? this.metricGroups() : null).add("NewGameSessionProtectionPolicy", (Object)this.newGameSessionProtectionPolicyAsString()).add("GameSessionCreationLimitPolicy", (Object)this.gameSessionCreationLimitPolicy()).add("LogConfiguration", (Object)this.logConfiguration()).add("RemoveAttributes", this.hasRemoveAttributes() ? this.removeAttributesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "GameServerContainerGroupDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.gameServerContainerGroupDefinitionName()));
            }
            case "PerInstanceContainerGroupDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.perInstanceContainerGroupDefinitionName()));
            }
            case "GameServerContainerGroupsPerInstance": {
                return Optional.ofNullable(clazz.cast(this.gameServerContainerGroupsPerInstance()));
            }
            case "InstanceConnectionPortRange": {
                return Optional.ofNullable(clazz.cast(this.instanceConnectionPortRange()));
            }
            case "InstanceInboundPermissionAuthorizations": {
                return Optional.ofNullable(clazz.cast(this.instanceInboundPermissionAuthorizations()));
            }
            case "InstanceInboundPermissionRevocations": {
                return Optional.ofNullable(clazz.cast(this.instanceInboundPermissionRevocations()));
            }
            case "DeploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MetricGroups": {
                return Optional.ofNullable(clazz.cast(this.metricGroups()));
            }
            case "NewGameSessionProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.newGameSessionProtectionPolicyAsString()));
            }
            case "GameSessionCreationLimitPolicy": {
                return Optional.ofNullable(clazz.cast(this.gameSessionCreationLimitPolicy()));
            }
            case "LogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "RemoveAttributes": {
                return Optional.ofNullable(clazz.cast(this.removeAttributesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("GameServerContainerGroupDefinitionName", GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("PerInstanceContainerGroupDefinitionName", PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("GameServerContainerGroupsPerInstance", GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD);
        map.put("InstanceConnectionPortRange", INSTANCE_CONNECTION_PORT_RANGE_FIELD);
        map.put("InstanceInboundPermissionAuthorizations", INSTANCE_INBOUND_PERMISSION_AUTHORIZATIONS_FIELD);
        map.put("InstanceInboundPermissionRevocations", INSTANCE_INBOUND_PERMISSION_REVOCATIONS_FIELD);
        map.put("DeploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("MetricGroups", METRIC_GROUPS_FIELD);
        map.put("NewGameSessionProtectionPolicy", NEW_GAME_SESSION_PROTECTION_POLICY_FIELD);
        map.put("GameSessionCreationLimitPolicy", GAME_SESSION_CREATION_LIMIT_POLICY_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("RemoveAttributes", REMOVE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContainerFleetRequest, T> g) {
        return obj -> g.apply((UpdateContainerFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String gameServerContainerGroupDefinitionName;
        private String perInstanceContainerGroupDefinitionName;
        private Integer gameServerContainerGroupsPerInstance;
        private ConnectionPortRange instanceConnectionPortRange;
        private List<IpPermission> instanceInboundPermissionAuthorizations = DefaultSdkAutoConstructList.getInstance();
        private List<IpPermission> instanceInboundPermissionRevocations = DefaultSdkAutoConstructList.getInstance();
        private DeploymentConfiguration deploymentConfiguration;
        private String description;
        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();
        private String newGameSessionProtectionPolicy;
        private GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;
        private LogConfiguration logConfiguration;
        private List<String> removeAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContainerFleetRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.gameServerContainerGroupDefinitionName(model.gameServerContainerGroupDefinitionName);
            this.perInstanceContainerGroupDefinitionName(model.perInstanceContainerGroupDefinitionName);
            this.gameServerContainerGroupsPerInstance(model.gameServerContainerGroupsPerInstance);
            this.instanceConnectionPortRange(model.instanceConnectionPortRange);
            this.instanceInboundPermissionAuthorizations(model.instanceInboundPermissionAuthorizations);
            this.instanceInboundPermissionRevocations(model.instanceInboundPermissionRevocations);
            this.deploymentConfiguration(model.deploymentConfiguration);
            this.description(model.description);
            this.metricGroups(model.metricGroups);
            this.newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.gameSessionCreationLimitPolicy(model.gameSessionCreationLimitPolicy);
            this.logConfiguration(model.logConfiguration);
            this.removeAttributesWithStrings(model.removeAttributes);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getGameServerContainerGroupDefinitionName() {
            return this.gameServerContainerGroupDefinitionName;
        }

        public final void setGameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
        }

        @Override
        public final Builder gameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
            return this;
        }

        public final String getPerInstanceContainerGroupDefinitionName() {
            return this.perInstanceContainerGroupDefinitionName;
        }

        public final void setPerInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
        }

        @Override
        public final Builder perInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
            return this;
        }

        public final Integer getGameServerContainerGroupsPerInstance() {
            return this.gameServerContainerGroupsPerInstance;
        }

        public final void setGameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
        }

        @Override
        public final Builder gameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
            return this;
        }

        public final ConnectionPortRange.Builder getInstanceConnectionPortRange() {
            return this.instanceConnectionPortRange != null ? this.instanceConnectionPortRange.toBuilder() : null;
        }

        public final void setInstanceConnectionPortRange(ConnectionPortRange.BuilderImpl instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange != null ? instanceConnectionPortRange.build() : null;
        }

        @Override
        public final Builder instanceConnectionPortRange(ConnectionPortRange instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange;
            return this;
        }

        public final List<IpPermission.Builder> getInstanceInboundPermissionAuthorizations() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.instanceInboundPermissionAuthorizations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceInboundPermissionAuthorizations(Collection<IpPermission.BuilderImpl> instanceInboundPermissionAuthorizations) {
            this.instanceInboundPermissionAuthorizations = IpPermissionsListCopier.copyFromBuilder(instanceInboundPermissionAuthorizations);
        }

        @Override
        public final Builder instanceInboundPermissionAuthorizations(Collection<IpPermission> instanceInboundPermissionAuthorizations) {
            this.instanceInboundPermissionAuthorizations = IpPermissionsListCopier.copy(instanceInboundPermissionAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissionAuthorizations(IpPermission ... instanceInboundPermissionAuthorizations) {
            this.instanceInboundPermissionAuthorizations(Arrays.asList(instanceInboundPermissionAuthorizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissionAuthorizations(Consumer<IpPermission.Builder> ... instanceInboundPermissionAuthorizations) {
            this.instanceInboundPermissionAuthorizations(Stream.of(instanceInboundPermissionAuthorizations).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IpPermission.Builder> getInstanceInboundPermissionRevocations() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.instanceInboundPermissionRevocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceInboundPermissionRevocations(Collection<IpPermission.BuilderImpl> instanceInboundPermissionRevocations) {
            this.instanceInboundPermissionRevocations = IpPermissionsListCopier.copyFromBuilder(instanceInboundPermissionRevocations);
        }

        @Override
        public final Builder instanceInboundPermissionRevocations(Collection<IpPermission> instanceInboundPermissionRevocations) {
            this.instanceInboundPermissionRevocations = IpPermissionsListCopier.copy(instanceInboundPermissionRevocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissionRevocations(IpPermission ... instanceInboundPermissionRevocations) {
            this.instanceInboundPermissionRevocations(Arrays.asList(instanceInboundPermissionRevocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissionRevocations(Consumer<IpPermission.Builder> ... instanceInboundPermissionRevocations) {
            this.instanceInboundPermissionRevocations(Stream.of(instanceInboundPermissionRevocations).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getMetricGroups() {
            if (this.metricGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricGroups;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final GameSessionCreationLimitPolicy.Builder getGameSessionCreationLimitPolicy() {
            return this.gameSessionCreationLimitPolicy != null ? this.gameSessionCreationLimitPolicy.toBuilder() : null;
        }

        public final void setGameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy.BuilderImpl gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy != null ? gameSessionCreationLimitPolicy.build() : null;
        }

        @Override
        public final Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final Collection<String> getRemoveAttributes() {
            if (this.removeAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeAttributes;
        }

        public final void setRemoveAttributes(Collection<String> removeAttributes) {
            this.removeAttributes = ContainerFleetRemoveAttributeListCopier.copy(removeAttributes);
        }

        @Override
        public final Builder removeAttributesWithStrings(Collection<String> removeAttributes) {
            this.removeAttributes = ContainerFleetRemoveAttributeListCopier.copy(removeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAttributesWithStrings(String ... removeAttributes) {
            this.removeAttributesWithStrings(Arrays.asList(removeAttributes));
            return this;
        }

        @Override
        public final Builder removeAttributes(Collection<ContainerFleetRemoveAttribute> removeAttributes) {
            this.removeAttributes = ContainerFleetRemoveAttributeListCopier.copyEnumToString(removeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAttributes(ContainerFleetRemoveAttribute ... removeAttributes) {
            this.removeAttributes(Arrays.asList(removeAttributes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContainerFleetRequest build() {
            return new UpdateContainerFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContainerFleetRequest> {
        public Builder fleetId(String var1);

        public Builder gameServerContainerGroupDefinitionName(String var1);

        public Builder perInstanceContainerGroupDefinitionName(String var1);

        public Builder gameServerContainerGroupsPerInstance(Integer var1);

        public Builder instanceConnectionPortRange(ConnectionPortRange var1);

        default public Builder instanceConnectionPortRange(Consumer<ConnectionPortRange.Builder> instanceConnectionPortRange) {
            return this.instanceConnectionPortRange((ConnectionPortRange)((ConnectionPortRange.Builder)ConnectionPortRange.builder().applyMutation(instanceConnectionPortRange)).build());
        }

        public Builder instanceInboundPermissionAuthorizations(Collection<IpPermission> var1);

        public Builder instanceInboundPermissionAuthorizations(IpPermission ... var1);

        public Builder instanceInboundPermissionAuthorizations(Consumer<IpPermission.Builder> ... var1);

        public Builder instanceInboundPermissionRevocations(Collection<IpPermission> var1);

        public Builder instanceInboundPermissionRevocations(IpPermission ... var1);

        public Builder instanceInboundPermissionRevocations(Consumer<IpPermission.Builder> ... var1);

        public Builder deploymentConfiguration(DeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy var1);

        default public Builder gameSessionCreationLimitPolicy(Consumer<GameSessionCreationLimitPolicy.Builder> gameSessionCreationLimitPolicy) {
            return this.gameSessionCreationLimitPolicy((GameSessionCreationLimitPolicy)((GameSessionCreationLimitPolicy.Builder)GameSessionCreationLimitPolicy.builder().applyMutation(gameSessionCreationLimitPolicy)).build());
        }

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder removeAttributesWithStrings(Collection<String> var1);

        public Builder removeAttributesWithStrings(String ... var1);

        public Builder removeAttributes(Collection<ContainerFleetRemoveAttribute> var1);

        public Builder removeAttributes(ContainerFleetRemoveAttribute ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

