/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.TerminationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateGameSessionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, TerminateGameSessionRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionId").getter(TerminateGameSessionRequest.getter(TerminateGameSessionRequest::gameSessionId)).setter(TerminateGameSessionRequest.setter(Builder::gameSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()}).build();
    private static final SdkField<String> TERMINATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TerminationMode").getter(TerminateGameSessionRequest.getter(TerminateGameSessionRequest::terminationModeAsString)).setter(TerminateGameSessionRequest.setter(Builder::terminationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD, TERMINATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TerminateGameSessionRequest.memberNameToFieldInitializer();
    private final String gameSessionId;
    private final String terminationMode;

    private TerminateGameSessionRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.terminationMode = builder.terminationMode;
    }

    public final String gameSessionId() {
        return this.gameSessionId;
    }

    public final TerminationMode terminationMode() {
        return TerminationMode.fromValue(this.terminationMode);
    }

    public final String terminationModeAsString() {
        return this.terminationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateGameSessionRequest)) {
            return false;
        }
        TerminateGameSessionRequest other = (TerminateGameSessionRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.terminationModeAsString(), other.terminationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TerminateGameSessionRequest").add("GameSessionId", (Object)this.gameSessionId()).add("TerminationMode", (Object)this.terminationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "TerminationMode": {
                return Optional.ofNullable(clazz.cast(this.terminationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GameSessionId", GAME_SESSION_ID_FIELD);
        map.put("TerminationMode", TERMINATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TerminateGameSessionRequest, T> g) {
        return obj -> g.apply((TerminateGameSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String terminationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateGameSessionRequest model) {
            super(model);
            this.gameSessionId(model.gameSessionId);
            this.terminationMode(model.terminationMode);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getTerminationMode() {
            return this.terminationMode;
        }

        public final void setTerminationMode(String terminationMode) {
            this.terminationMode = terminationMode;
        }

        @Override
        public final Builder terminationMode(String terminationMode) {
            this.terminationMode = terminationMode;
            return this;
        }

        @Override
        public final Builder terminationMode(TerminationMode terminationMode) {
            this.terminationMode(terminationMode == null ? null : terminationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateGameSessionRequest build() {
            return new TerminateGameSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TerminateGameSessionRequest> {
        public Builder gameSessionId(String var1);

        public Builder terminationMode(String var1);

        public Builder terminationMode(TerminationMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

