/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ConnectionPortRange;
import software.amazon.awssdk.services.gamelift.model.ContainerFleetBillingType;
import software.amazon.awssdk.services.gamelift.model.ContainerFleetLocationAttributes;
import software.amazon.awssdk.services.gamelift.model.ContainerFleetLocationAttributesListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerFleetStatus;
import software.amazon.awssdk.services.gamelift.model.DeploymentDetails;
import software.amazon.awssdk.services.gamelift.model.GameSessionCreationLimitPolicy;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.services.gamelift.model.LogConfiguration;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerFleet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerFleet> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(ContainerFleet.getter(ContainerFleet::fleetId)).setter(ContainerFleet.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(ContainerFleet.getter(ContainerFleet::fleetArn)).setter(ContainerFleet.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> FLEET_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetRoleArn").getter(ContainerFleet.getter(ContainerFleet::fleetRoleArn)).setter(ContainerFleet.setter(Builder::fleetRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetRoleArn").build()}).build();
    private static final SdkField<String> GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerContainerGroupDefinitionName").getter(ContainerFleet.getter(ContainerFleet::gameServerContainerGroupDefinitionName)).setter(ContainerFleet.setter(Builder::gameServerContainerGroupDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerGroupDefinitionName").build()}).build();
    private static final SdkField<String> GAME_SERVER_CONTAINER_GROUP_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerContainerGroupDefinitionArn").getter(ContainerFleet.getter(ContainerFleet::gameServerContainerGroupDefinitionArn)).setter(ContainerFleet.setter(Builder::gameServerContainerGroupDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerGroupDefinitionArn").build()}).build();
    private static final SdkField<String> PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerInstanceContainerGroupDefinitionName").getter(ContainerFleet.getter(ContainerFleet::perInstanceContainerGroupDefinitionName)).setter(ContainerFleet.setter(Builder::perInstanceContainerGroupDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerInstanceContainerGroupDefinitionName").build()}).build();
    private static final SdkField<String> PER_INSTANCE_CONTAINER_GROUP_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerInstanceContainerGroupDefinitionArn").getter(ContainerFleet.getter(ContainerFleet::perInstanceContainerGroupDefinitionArn)).setter(ContainerFleet.setter(Builder::perInstanceContainerGroupDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerInstanceContainerGroupDefinitionArn").build()}).build();
    private static final SdkField<ConnectionPortRange> INSTANCE_CONNECTION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceConnectionPortRange").getter(ContainerFleet.getter(ContainerFleet::instanceConnectionPortRange)).setter(ContainerFleet.setter(Builder::instanceConnectionPortRange)).constructor(ConnectionPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectionPortRange").build()}).build();
    private static final SdkField<List<IpPermission>> INSTANCE_INBOUND_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceInboundPermissions").getter(ContainerFleet.getter(ContainerFleet::instanceInboundPermissions)).setter(ContainerFleet.setter(Builder::instanceInboundPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInboundPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GameServerContainerGroupsPerInstance").getter(ContainerFleet.getter(ContainerFleet::gameServerContainerGroupsPerInstance)).setter(ContainerFleet.setter(Builder::gameServerContainerGroupsPerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerContainerGroupsPerInstance").build()}).build();
    private static final SdkField<Integer> MAXIMUM_GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumGameServerContainerGroupsPerInstance").getter(ContainerFleet.getter(ContainerFleet::maximumGameServerContainerGroupsPerInstance)).setter(ContainerFleet.setter(Builder::maximumGameServerContainerGroupsPerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumGameServerContainerGroupsPerInstance").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ContainerFleet.getter(ContainerFleet::instanceType)).setter(ContainerFleet.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> BILLING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingType").getter(ContainerFleet.getter(ContainerFleet::billingTypeAsString)).setter(ContainerFleet.setter(Builder::billingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ContainerFleet.getter(ContainerFleet::description)).setter(ContainerFleet.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ContainerFleet.getter(ContainerFleet::creationTime)).setter(ContainerFleet.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricGroups").getter(ContainerFleet.getter(ContainerFleet::metricGroups)).setter(ContainerFleet.setter(Builder::metricGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewGameSessionProtectionPolicy").getter(ContainerFleet.getter(ContainerFleet::newGameSessionProtectionPolicyAsString)).setter(ContainerFleet.setter(Builder::newGameSessionProtectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy").build()}).build();
    private static final SdkField<GameSessionCreationLimitPolicy> GAME_SESSION_CREATION_LIMIT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GameSessionCreationLimitPolicy").getter(ContainerFleet.getter(ContainerFleet::gameSessionCreationLimitPolicy)).setter(ContainerFleet.setter(Builder::gameSessionCreationLimitPolicy)).constructor(GameSessionCreationLimitPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionCreationLimitPolicy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ContainerFleet.getter(ContainerFleet::statusAsString)).setter(ContainerFleet.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<DeploymentDetails> DEPLOYMENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentDetails").getter(ContainerFleet.getter(ContainerFleet::deploymentDetails)).setter(ContainerFleet.setter(Builder::deploymentDetails)).constructor(DeploymentDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDetails").build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfiguration").getter(ContainerFleet.getter(ContainerFleet::logConfiguration)).setter(ContainerFleet.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()}).build();
    private static final SdkField<List<ContainerFleetLocationAttributes>> LOCATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocationAttributes").getter(ContainerFleet.getter(ContainerFleet::locationAttributes)).setter(ContainerFleet.setter(Builder::locationAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerFleetLocationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, FLEET_ROLE_ARN_FIELD, GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD, GAME_SERVER_CONTAINER_GROUP_DEFINITION_ARN_FIELD, PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD, PER_INSTANCE_CONTAINER_GROUP_DEFINITION_ARN_FIELD, INSTANCE_CONNECTION_PORT_RANGE_FIELD, INSTANCE_INBOUND_PERMISSIONS_FIELD, GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD, MAXIMUM_GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD, INSTANCE_TYPE_FIELD, BILLING_TYPE_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, METRIC_GROUPS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD, GAME_SESSION_CREATION_LIMIT_POLICY_FIELD, STATUS_FIELD, DEPLOYMENT_DETAILS_FIELD, LOG_CONFIGURATION_FIELD, LOCATION_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerFleet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final String fleetArn;
    private final String fleetRoleArn;
    private final String gameServerContainerGroupDefinitionName;
    private final String gameServerContainerGroupDefinitionArn;
    private final String perInstanceContainerGroupDefinitionName;
    private final String perInstanceContainerGroupDefinitionArn;
    private final ConnectionPortRange instanceConnectionPortRange;
    private final List<IpPermission> instanceInboundPermissions;
    private final Integer gameServerContainerGroupsPerInstance;
    private final Integer maximumGameServerContainerGroupsPerInstance;
    private final String instanceType;
    private final String billingType;
    private final String description;
    private final Instant creationTime;
    private final List<String> metricGroups;
    private final String newGameSessionProtectionPolicy;
    private final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;
    private final String status;
    private final DeploymentDetails deploymentDetails;
    private final LogConfiguration logConfiguration;
    private final List<ContainerFleetLocationAttributes> locationAttributes;

    private ContainerFleet(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.fleetRoleArn = builder.fleetRoleArn;
        this.gameServerContainerGroupDefinitionName = builder.gameServerContainerGroupDefinitionName;
        this.gameServerContainerGroupDefinitionArn = builder.gameServerContainerGroupDefinitionArn;
        this.perInstanceContainerGroupDefinitionName = builder.perInstanceContainerGroupDefinitionName;
        this.perInstanceContainerGroupDefinitionArn = builder.perInstanceContainerGroupDefinitionArn;
        this.instanceConnectionPortRange = builder.instanceConnectionPortRange;
        this.instanceInboundPermissions = builder.instanceInboundPermissions;
        this.gameServerContainerGroupsPerInstance = builder.gameServerContainerGroupsPerInstance;
        this.maximumGameServerContainerGroupsPerInstance = builder.maximumGameServerContainerGroupsPerInstance;
        this.instanceType = builder.instanceType;
        this.billingType = builder.billingType;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.metricGroups = builder.metricGroups;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.gameSessionCreationLimitPolicy = builder.gameSessionCreationLimitPolicy;
        this.status = builder.status;
        this.deploymentDetails = builder.deploymentDetails;
        this.logConfiguration = builder.logConfiguration;
        this.locationAttributes = builder.locationAttributes;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final String fleetRoleArn() {
        return this.fleetRoleArn;
    }

    public final String gameServerContainerGroupDefinitionName() {
        return this.gameServerContainerGroupDefinitionName;
    }

    public final String gameServerContainerGroupDefinitionArn() {
        return this.gameServerContainerGroupDefinitionArn;
    }

    public final String perInstanceContainerGroupDefinitionName() {
        return this.perInstanceContainerGroupDefinitionName;
    }

    public final String perInstanceContainerGroupDefinitionArn() {
        return this.perInstanceContainerGroupDefinitionArn;
    }

    public final ConnectionPortRange instanceConnectionPortRange() {
        return this.instanceConnectionPortRange;
    }

    public final boolean hasInstanceInboundPermissions() {
        return this.instanceInboundPermissions != null && !(this.instanceInboundPermissions instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> instanceInboundPermissions() {
        return this.instanceInboundPermissions;
    }

    public final Integer gameServerContainerGroupsPerInstance() {
        return this.gameServerContainerGroupsPerInstance;
    }

    public final Integer maximumGameServerContainerGroupsPerInstance() {
        return this.maximumGameServerContainerGroupsPerInstance;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final ContainerFleetBillingType billingType() {
        return ContainerFleetBillingType.fromValue(this.billingType);
    }

    public final String billingTypeAsString() {
        return this.billingType;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasMetricGroups() {
        return this.metricGroups != null && !(this.metricGroups instanceof SdkAutoConstructList);
    }

    public final List<String> metricGroups() {
        return this.metricGroups;
    }

    public final ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(this.newGameSessionProtectionPolicy);
    }

    public final String newGameSessionProtectionPolicyAsString() {
        return this.newGameSessionProtectionPolicy;
    }

    public final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy() {
        return this.gameSessionCreationLimitPolicy;
    }

    public final ContainerFleetStatus status() {
        return ContainerFleetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final DeploymentDetails deploymentDetails() {
        return this.deploymentDetails;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final boolean hasLocationAttributes() {
        return this.locationAttributes != null && !(this.locationAttributes instanceof SdkAutoConstructList);
    }

    public final List<ContainerFleetLocationAttributes> locationAttributes() {
        return this.locationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerContainerGroupDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.perInstanceContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.perInstanceContainerGroupDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConnectionPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceInboundPermissions() ? this.instanceInboundPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerContainerGroupsPerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumGameServerContainerGroupsPerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricGroups() ? this.metricGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationAttributes() ? this.locationAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerFleet)) {
            return false;
        }
        ContainerFleet other = (ContainerFleet)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.fleetRoleArn(), other.fleetRoleArn()) && Objects.equals(this.gameServerContainerGroupDefinitionName(), other.gameServerContainerGroupDefinitionName()) && Objects.equals(this.gameServerContainerGroupDefinitionArn(), other.gameServerContainerGroupDefinitionArn()) && Objects.equals(this.perInstanceContainerGroupDefinitionName(), other.perInstanceContainerGroupDefinitionName()) && Objects.equals(this.perInstanceContainerGroupDefinitionArn(), other.perInstanceContainerGroupDefinitionArn()) && Objects.equals(this.instanceConnectionPortRange(), other.instanceConnectionPortRange()) && this.hasInstanceInboundPermissions() == other.hasInstanceInboundPermissions() && Objects.equals(this.instanceInboundPermissions(), other.instanceInboundPermissions()) && Objects.equals(this.gameServerContainerGroupsPerInstance(), other.gameServerContainerGroupsPerInstance()) && Objects.equals(this.maximumGameServerContainerGroupsPerInstance(), other.maximumGameServerContainerGroupsPerInstance()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.billingTypeAsString(), other.billingTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasMetricGroups() == other.hasMetricGroups() && Objects.equals(this.metricGroups(), other.metricGroups()) && Objects.equals(this.newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString()) && Objects.equals(this.gameSessionCreationLimitPolicy(), other.gameSessionCreationLimitPolicy()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.deploymentDetails(), other.deploymentDetails()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && this.hasLocationAttributes() == other.hasLocationAttributes() && Objects.equals(this.locationAttributes(), other.locationAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerFleet").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("FleetRoleArn", (Object)this.fleetRoleArn()).add("GameServerContainerGroupDefinitionName", (Object)this.gameServerContainerGroupDefinitionName()).add("GameServerContainerGroupDefinitionArn", (Object)this.gameServerContainerGroupDefinitionArn()).add("PerInstanceContainerGroupDefinitionName", (Object)this.perInstanceContainerGroupDefinitionName()).add("PerInstanceContainerGroupDefinitionArn", (Object)this.perInstanceContainerGroupDefinitionArn()).add("InstanceConnectionPortRange", (Object)this.instanceConnectionPortRange()).add("InstanceInboundPermissions", this.hasInstanceInboundPermissions() ? this.instanceInboundPermissions() : null).add("GameServerContainerGroupsPerInstance", (Object)this.gameServerContainerGroupsPerInstance()).add("MaximumGameServerContainerGroupsPerInstance", (Object)this.maximumGameServerContainerGroupsPerInstance()).add("InstanceType", (Object)this.instanceType()).add("BillingType", (Object)this.billingTypeAsString()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("MetricGroups", this.hasMetricGroups() ? this.metricGroups() : null).add("NewGameSessionProtectionPolicy", (Object)this.newGameSessionProtectionPolicyAsString()).add("GameSessionCreationLimitPolicy", (Object)this.gameSessionCreationLimitPolicy()).add("Status", (Object)this.statusAsString()).add("DeploymentDetails", (Object)this.deploymentDetails()).add("LogConfiguration", (Object)this.logConfiguration()).add("LocationAttributes", this.hasLocationAttributes() ? this.locationAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "FleetRoleArn": {
                return Optional.ofNullable(clazz.cast(this.fleetRoleArn()));
            }
            case "GameServerContainerGroupDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.gameServerContainerGroupDefinitionName()));
            }
            case "GameServerContainerGroupDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.gameServerContainerGroupDefinitionArn()));
            }
            case "PerInstanceContainerGroupDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.perInstanceContainerGroupDefinitionName()));
            }
            case "PerInstanceContainerGroupDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.perInstanceContainerGroupDefinitionArn()));
            }
            case "InstanceConnectionPortRange": {
                return Optional.ofNullable(clazz.cast(this.instanceConnectionPortRange()));
            }
            case "InstanceInboundPermissions": {
                return Optional.ofNullable(clazz.cast(this.instanceInboundPermissions()));
            }
            case "GameServerContainerGroupsPerInstance": {
                return Optional.ofNullable(clazz.cast(this.gameServerContainerGroupsPerInstance()));
            }
            case "MaximumGameServerContainerGroupsPerInstance": {
                return Optional.ofNullable(clazz.cast(this.maximumGameServerContainerGroupsPerInstance()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "BillingType": {
                return Optional.ofNullable(clazz.cast(this.billingTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "MetricGroups": {
                return Optional.ofNullable(clazz.cast(this.metricGroups()));
            }
            case "NewGameSessionProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.newGameSessionProtectionPolicyAsString()));
            }
            case "GameSessionCreationLimitPolicy": {
                return Optional.ofNullable(clazz.cast(this.gameSessionCreationLimitPolicy()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DeploymentDetails": {
                return Optional.ofNullable(clazz.cast(this.deploymentDetails()));
            }
            case "LogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "LocationAttributes": {
                return Optional.ofNullable(clazz.cast(this.locationAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("FleetArn", FLEET_ARN_FIELD);
        map.put("FleetRoleArn", FLEET_ROLE_ARN_FIELD);
        map.put("GameServerContainerGroupDefinitionName", GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("GameServerContainerGroupDefinitionArn", GAME_SERVER_CONTAINER_GROUP_DEFINITION_ARN_FIELD);
        map.put("PerInstanceContainerGroupDefinitionName", PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("PerInstanceContainerGroupDefinitionArn", PER_INSTANCE_CONTAINER_GROUP_DEFINITION_ARN_FIELD);
        map.put("InstanceConnectionPortRange", INSTANCE_CONNECTION_PORT_RANGE_FIELD);
        map.put("InstanceInboundPermissions", INSTANCE_INBOUND_PERMISSIONS_FIELD);
        map.put("GameServerContainerGroupsPerInstance", GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD);
        map.put("MaximumGameServerContainerGroupsPerInstance", MAXIMUM_GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("BillingType", BILLING_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("MetricGroups", METRIC_GROUPS_FIELD);
        map.put("NewGameSessionProtectionPolicy", NEW_GAME_SESSION_PROTECTION_POLICY_FIELD);
        map.put("GameSessionCreationLimitPolicy", GAME_SESSION_CREATION_LIMIT_POLICY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DeploymentDetails", DEPLOYMENT_DETAILS_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("LocationAttributes", LOCATION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerFleet, T> g) {
        return obj -> g.apply((ContainerFleet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String fleetRoleArn;
        private String gameServerContainerGroupDefinitionName;
        private String gameServerContainerGroupDefinitionArn;
        private String perInstanceContainerGroupDefinitionName;
        private String perInstanceContainerGroupDefinitionArn;
        private ConnectionPortRange instanceConnectionPortRange;
        private List<IpPermission> instanceInboundPermissions = DefaultSdkAutoConstructList.getInstance();
        private Integer gameServerContainerGroupsPerInstance;
        private Integer maximumGameServerContainerGroupsPerInstance;
        private String instanceType;
        private String billingType;
        private String description;
        private Instant creationTime;
        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();
        private String newGameSessionProtectionPolicy;
        private GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;
        private String status;
        private DeploymentDetails deploymentDetails;
        private LogConfiguration logConfiguration;
        private List<ContainerFleetLocationAttributes> locationAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerFleet model) {
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.fleetRoleArn(model.fleetRoleArn);
            this.gameServerContainerGroupDefinitionName(model.gameServerContainerGroupDefinitionName);
            this.gameServerContainerGroupDefinitionArn(model.gameServerContainerGroupDefinitionArn);
            this.perInstanceContainerGroupDefinitionName(model.perInstanceContainerGroupDefinitionName);
            this.perInstanceContainerGroupDefinitionArn(model.perInstanceContainerGroupDefinitionArn);
            this.instanceConnectionPortRange(model.instanceConnectionPortRange);
            this.instanceInboundPermissions(model.instanceInboundPermissions);
            this.gameServerContainerGroupsPerInstance(model.gameServerContainerGroupsPerInstance);
            this.maximumGameServerContainerGroupsPerInstance(model.maximumGameServerContainerGroupsPerInstance);
            this.instanceType(model.instanceType);
            this.billingType(model.billingType);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.metricGroups(model.metricGroups);
            this.newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.gameSessionCreationLimitPolicy(model.gameSessionCreationLimitPolicy);
            this.status(model.status);
            this.deploymentDetails(model.deploymentDetails);
            this.logConfiguration(model.logConfiguration);
            this.locationAttributes(model.locationAttributes);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getFleetRoleArn() {
            return this.fleetRoleArn;
        }

        public final void setFleetRoleArn(String fleetRoleArn) {
            this.fleetRoleArn = fleetRoleArn;
        }

        @Override
        public final Builder fleetRoleArn(String fleetRoleArn) {
            this.fleetRoleArn = fleetRoleArn;
            return this;
        }

        public final String getGameServerContainerGroupDefinitionName() {
            return this.gameServerContainerGroupDefinitionName;
        }

        public final void setGameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
        }

        @Override
        public final Builder gameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
            return this;
        }

        public final String getGameServerContainerGroupDefinitionArn() {
            return this.gameServerContainerGroupDefinitionArn;
        }

        public final void setGameServerContainerGroupDefinitionArn(String gameServerContainerGroupDefinitionArn) {
            this.gameServerContainerGroupDefinitionArn = gameServerContainerGroupDefinitionArn;
        }

        @Override
        public final Builder gameServerContainerGroupDefinitionArn(String gameServerContainerGroupDefinitionArn) {
            this.gameServerContainerGroupDefinitionArn = gameServerContainerGroupDefinitionArn;
            return this;
        }

        public final String getPerInstanceContainerGroupDefinitionName() {
            return this.perInstanceContainerGroupDefinitionName;
        }

        public final void setPerInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
        }

        @Override
        public final Builder perInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
            return this;
        }

        public final String getPerInstanceContainerGroupDefinitionArn() {
            return this.perInstanceContainerGroupDefinitionArn;
        }

        public final void setPerInstanceContainerGroupDefinitionArn(String perInstanceContainerGroupDefinitionArn) {
            this.perInstanceContainerGroupDefinitionArn = perInstanceContainerGroupDefinitionArn;
        }

        @Override
        public final Builder perInstanceContainerGroupDefinitionArn(String perInstanceContainerGroupDefinitionArn) {
            this.perInstanceContainerGroupDefinitionArn = perInstanceContainerGroupDefinitionArn;
            return this;
        }

        public final ConnectionPortRange.Builder getInstanceConnectionPortRange() {
            return this.instanceConnectionPortRange != null ? this.instanceConnectionPortRange.toBuilder() : null;
        }

        public final void setInstanceConnectionPortRange(ConnectionPortRange.BuilderImpl instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange != null ? instanceConnectionPortRange.build() : null;
        }

        @Override
        public final Builder instanceConnectionPortRange(ConnectionPortRange instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange;
            return this;
        }

        public final List<IpPermission.Builder> getInstanceInboundPermissions() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.instanceInboundPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceInboundPermissions(Collection<IpPermission.BuilderImpl> instanceInboundPermissions) {
            this.instanceInboundPermissions = IpPermissionsListCopier.copyFromBuilder(instanceInboundPermissions);
        }

        @Override
        public final Builder instanceInboundPermissions(Collection<IpPermission> instanceInboundPermissions) {
            this.instanceInboundPermissions = IpPermissionsListCopier.copy(instanceInboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissions(IpPermission ... instanceInboundPermissions) {
            this.instanceInboundPermissions(Arrays.asList(instanceInboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissions(Consumer<IpPermission.Builder> ... instanceInboundPermissions) {
            this.instanceInboundPermissions(Stream.of(instanceInboundPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getGameServerContainerGroupsPerInstance() {
            return this.gameServerContainerGroupsPerInstance;
        }

        public final void setGameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
        }

        @Override
        public final Builder gameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
            return this;
        }

        public final Integer getMaximumGameServerContainerGroupsPerInstance() {
            return this.maximumGameServerContainerGroupsPerInstance;
        }

        public final void setMaximumGameServerContainerGroupsPerInstance(Integer maximumGameServerContainerGroupsPerInstance) {
            this.maximumGameServerContainerGroupsPerInstance = maximumGameServerContainerGroupsPerInstance;
        }

        @Override
        public final Builder maximumGameServerContainerGroupsPerInstance(Integer maximumGameServerContainerGroupsPerInstance) {
            this.maximumGameServerContainerGroupsPerInstance = maximumGameServerContainerGroupsPerInstance;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getBillingType() {
            return this.billingType;
        }

        public final void setBillingType(String billingType) {
            this.billingType = billingType;
        }

        @Override
        public final Builder billingType(String billingType) {
            this.billingType = billingType;
            return this;
        }

        @Override
        public final Builder billingType(ContainerFleetBillingType billingType) {
            this.billingType(billingType == null ? null : billingType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Collection<String> getMetricGroups() {
            if (this.metricGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricGroups;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final GameSessionCreationLimitPolicy.Builder getGameSessionCreationLimitPolicy() {
            return this.gameSessionCreationLimitPolicy != null ? this.gameSessionCreationLimitPolicy.toBuilder() : null;
        }

        public final void setGameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy.BuilderImpl gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy != null ? gameSessionCreationLimitPolicy.build() : null;
        }

        @Override
        public final Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContainerFleetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DeploymentDetails.Builder getDeploymentDetails() {
            return this.deploymentDetails != null ? this.deploymentDetails.toBuilder() : null;
        }

        public final void setDeploymentDetails(DeploymentDetails.BuilderImpl deploymentDetails) {
            this.deploymentDetails = deploymentDetails != null ? deploymentDetails.build() : null;
        }

        @Override
        public final Builder deploymentDetails(DeploymentDetails deploymentDetails) {
            this.deploymentDetails = deploymentDetails;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final List<ContainerFleetLocationAttributes.Builder> getLocationAttributes() {
            List<ContainerFleetLocationAttributes.Builder> result = ContainerFleetLocationAttributesListCopier.copyToBuilder(this.locationAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationAttributes(Collection<ContainerFleetLocationAttributes.BuilderImpl> locationAttributes) {
            this.locationAttributes = ContainerFleetLocationAttributesListCopier.copyFromBuilder(locationAttributes);
        }

        @Override
        public final Builder locationAttributes(Collection<ContainerFleetLocationAttributes> locationAttributes) {
            this.locationAttributes = ContainerFleetLocationAttributesListCopier.copy(locationAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationAttributes(ContainerFleetLocationAttributes ... locationAttributes) {
            this.locationAttributes(Arrays.asList(locationAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationAttributes(Consumer<ContainerFleetLocationAttributes.Builder> ... locationAttributes) {
            this.locationAttributes(Stream.of(locationAttributes).map(c -> (ContainerFleetLocationAttributes)((ContainerFleetLocationAttributes.Builder)ContainerFleetLocationAttributes.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContainerFleet build() {
            return new ContainerFleet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerFleet> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder fleetRoleArn(String var1);

        public Builder gameServerContainerGroupDefinitionName(String var1);

        public Builder gameServerContainerGroupDefinitionArn(String var1);

        public Builder perInstanceContainerGroupDefinitionName(String var1);

        public Builder perInstanceContainerGroupDefinitionArn(String var1);

        public Builder instanceConnectionPortRange(ConnectionPortRange var1);

        default public Builder instanceConnectionPortRange(Consumer<ConnectionPortRange.Builder> instanceConnectionPortRange) {
            return this.instanceConnectionPortRange((ConnectionPortRange)((ConnectionPortRange.Builder)ConnectionPortRange.builder().applyMutation(instanceConnectionPortRange)).build());
        }

        public Builder instanceInboundPermissions(Collection<IpPermission> var1);

        public Builder instanceInboundPermissions(IpPermission ... var1);

        public Builder instanceInboundPermissions(Consumer<IpPermission.Builder> ... var1);

        public Builder gameServerContainerGroupsPerInstance(Integer var1);

        public Builder maximumGameServerContainerGroupsPerInstance(Integer var1);

        public Builder instanceType(String var1);

        public Builder billingType(String var1);

        public Builder billingType(ContainerFleetBillingType var1);

        public Builder description(String var1);

        public Builder creationTime(Instant var1);

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy var1);

        default public Builder gameSessionCreationLimitPolicy(Consumer<GameSessionCreationLimitPolicy.Builder> gameSessionCreationLimitPolicy) {
            return this.gameSessionCreationLimitPolicy((GameSessionCreationLimitPolicy)((GameSessionCreationLimitPolicy.Builder)GameSessionCreationLimitPolicy.builder().applyMutation(gameSessionCreationLimitPolicy)).build());
        }

        public Builder status(String var1);

        public Builder status(ContainerFleetStatus var1);

        public Builder deploymentDetails(DeploymentDetails var1);

        default public Builder deploymentDetails(Consumer<DeploymentDetails.Builder> deploymentDetails) {
            return this.deploymentDetails((DeploymentDetails)((DeploymentDetails.Builder)DeploymentDetails.builder().applyMutation(deploymentDetails)).build());
        }

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder locationAttributes(Collection<ContainerFleetLocationAttributes> var1);

        public Builder locationAttributes(ContainerFleetLocationAttributes ... var1);

        public Builder locationAttributes(Consumer<ContainerFleetLocationAttributes.Builder> ... var1);
    }
}

