/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeFileCachesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileCachesResponse;

public class DescribeFileCachesPublisher
implements SdkPublisher<DescribeFileCachesResponse> {
    private final FSxAsyncClient client;
    private final DescribeFileCachesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFileCachesPublisher(FSxAsyncClient client, DescribeFileCachesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFileCachesPublisher(FSxAsyncClient client, DescribeFileCachesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFileCachesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFileCachesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeFileCachesResponseFetcher
    implements AsyncPageFetcher<DescribeFileCachesResponse> {
        private DescribeFileCachesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFileCachesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFileCachesResponse> nextPage(DescribeFileCachesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFileCachesPublisher.this.client.describeFileCaches(DescribeFileCachesPublisher.this.firstRequest);
            }
            return DescribeFileCachesPublisher.this.client.describeFileCaches((DescribeFileCachesRequest)((Object)DescribeFileCachesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

