/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.Alias;
import software.amazon.awssdk.services.fsx.model.AliasesCopier;
import software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration;
import software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation;
import software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperationsCopier;
import software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes;
import software.amazon.awssdk.services.fsx.model.WindowsAuditLogConfiguration;
import software.amazon.awssdk.services.fsx.model.WindowsDeploymentType;
import software.amazon.awssdk.services.fsx.model.WindowsFsrmConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WindowsFileSystemConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WindowsFileSystemConfiguration> {
    private static final SdkField<String> ACTIVE_DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveDirectoryId").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::activeDirectoryId)).setter(WindowsFileSystemConfiguration.setter(Builder::activeDirectoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryId").build()}).build();
    private static final SdkField<SelfManagedActiveDirectoryAttributes> SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedActiveDirectoryConfiguration").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::selfManagedActiveDirectoryConfiguration)).setter(WindowsFileSystemConfiguration.setter(Builder::selfManagedActiveDirectoryConfiguration)).constructor(SelfManagedActiveDirectoryAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedActiveDirectoryConfiguration").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::deploymentTypeAsString)).setter(WindowsFileSystemConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<String> REMOTE_ADMINISTRATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteAdministrationEndpoint").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::remoteAdministrationEndpoint)).setter(WindowsFileSystemConfiguration.setter(Builder::remoteAdministrationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteAdministrationEndpoint").build()}).build();
    private static final SdkField<String> PREFERRED_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredSubnetId").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::preferredSubnetId)).setter(WindowsFileSystemConfiguration.setter(Builder::preferredSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredSubnetId").build()}).build();
    private static final SdkField<String> PREFERRED_FILE_SERVER_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredFileServerIp").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::preferredFileServerIp)).setter(WindowsFileSystemConfiguration.setter(Builder::preferredFileServerIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredFileServerIp").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacity").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::throughputCapacity)).setter(WindowsFileSystemConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<List<String>> MAINTENANCE_OPERATIONS_IN_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MaintenanceOperationsInProgress").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::maintenanceOperationsInProgressAsStrings)).setter(WindowsFileSystemConfiguration.setter(Builder::maintenanceOperationsInProgressWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOperationsInProgress").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::weeklyMaintenanceStartTime)).setter(WindowsFileSystemConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::dailyAutomaticBackupStartTime)).setter(WindowsFileSystemConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::automaticBackupRetentionDays)).setter(WindowsFileSystemConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToBackups").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::copyTagsToBackups)).setter(WindowsFileSystemConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final SdkField<List<Alias>> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aliases").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::aliases)).setter(WindowsFileSystemConfiguration.setter(Builder::aliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WindowsAuditLogConfiguration> AUDIT_LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuditLogConfiguration").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::auditLogConfiguration)).setter(WindowsFileSystemConfiguration.setter(Builder::auditLogConfiguration)).constructor(WindowsAuditLogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogConfiguration").build()}).build();
    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::diskIopsConfiguration)).setter(WindowsFileSystemConfiguration.setter(Builder::diskIopsConfiguration)).constructor(DiskIopsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build()}).build();
    private static final SdkField<String> PREFERRED_FILE_SERVER_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredFileServerIpv6").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::preferredFileServerIpv6)).setter(WindowsFileSystemConfiguration.setter(Builder::preferredFileServerIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredFileServerIpv6").build()}).build();
    private static final SdkField<WindowsFsrmConfiguration> FSRM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FsrmConfiguration").getter(WindowsFileSystemConfiguration.getter(WindowsFileSystemConfiguration::fsrmConfiguration)).setter(WindowsFileSystemConfiguration.setter(Builder::fsrmConfiguration)).constructor(WindowsFsrmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsrmConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_ID_FIELD, SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD, DEPLOYMENT_TYPE_FIELD, REMOTE_ADMINISTRATION_ENDPOINT_FIELD, PREFERRED_SUBNET_ID_FIELD, PREFERRED_FILE_SERVER_IP_FIELD, THROUGHPUT_CAPACITY_FIELD, MAINTENANCE_OPERATIONS_IN_PROGRESS_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, ALIASES_FIELD, AUDIT_LOG_CONFIGURATION_FIELD, DISK_IOPS_CONFIGURATION_FIELD, PREFERRED_FILE_SERVER_IPV6_FIELD, FSRM_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WindowsFileSystemConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String activeDirectoryId;
    private final SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration;
    private final String deploymentType;
    private final String remoteAdministrationEndpoint;
    private final String preferredSubnetId;
    private final String preferredFileServerIp;
    private final Integer throughputCapacity;
    private final List<String> maintenanceOperationsInProgress;
    private final String weeklyMaintenanceStartTime;
    private final String dailyAutomaticBackupStartTime;
    private final Integer automaticBackupRetentionDays;
    private final Boolean copyTagsToBackups;
    private final List<Alias> aliases;
    private final WindowsAuditLogConfiguration auditLogConfiguration;
    private final DiskIopsConfiguration diskIopsConfiguration;
    private final String preferredFileServerIpv6;
    private final WindowsFsrmConfiguration fsrmConfiguration;

    private WindowsFileSystemConfiguration(BuilderImpl builder) {
        this.activeDirectoryId = builder.activeDirectoryId;
        this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
        this.deploymentType = builder.deploymentType;
        this.remoteAdministrationEndpoint = builder.remoteAdministrationEndpoint;
        this.preferredSubnetId = builder.preferredSubnetId;
        this.preferredFileServerIp = builder.preferredFileServerIp;
        this.throughputCapacity = builder.throughputCapacity;
        this.maintenanceOperationsInProgress = builder.maintenanceOperationsInProgress;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.aliases = builder.aliases;
        this.auditLogConfiguration = builder.auditLogConfiguration;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.preferredFileServerIpv6 = builder.preferredFileServerIpv6;
        this.fsrmConfiguration = builder.fsrmConfiguration;
    }

    public final String activeDirectoryId() {
        return this.activeDirectoryId;
    }

    public final SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration() {
        return this.selfManagedActiveDirectoryConfiguration;
    }

    public final WindowsDeploymentType deploymentType() {
        return WindowsDeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final String remoteAdministrationEndpoint() {
        return this.remoteAdministrationEndpoint;
    }

    public final String preferredSubnetId() {
        return this.preferredSubnetId;
    }

    public final String preferredFileServerIp() {
        return this.preferredFileServerIp;
    }

    public final Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public final List<FileSystemMaintenanceOperation> maintenanceOperationsInProgress() {
        return FileSystemMaintenanceOperationsCopier.copyStringToEnum(this.maintenanceOperationsInProgress);
    }

    public final boolean hasMaintenanceOperationsInProgress() {
        return this.maintenanceOperationsInProgress != null && !(this.maintenanceOperationsInProgress instanceof SdkAutoConstructList);
    }

    public final List<String> maintenanceOperationsInProgressAsStrings() {
        return this.maintenanceOperationsInProgress;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public final boolean hasAliases() {
        return this.aliases != null && !(this.aliases instanceof SdkAutoConstructList);
    }

    public final List<Alias> aliases() {
        return this.aliases;
    }

    public final WindowsAuditLogConfiguration auditLogConfiguration() {
        return this.auditLogConfiguration;
    }

    public final DiskIopsConfiguration diskIopsConfiguration() {
        return this.diskIopsConfiguration;
    }

    public final String preferredFileServerIpv6() {
        return this.preferredFileServerIpv6;
    }

    public final WindowsFsrmConfiguration fsrmConfiguration() {
        return this.fsrmConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedActiveDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAdministrationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredFileServerIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMaintenanceOperationsInProgress() ? this.maintenanceOperationsInProgressAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliases() ? this.aliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.auditLogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredFileServerIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.fsrmConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowsFileSystemConfiguration)) {
            return false;
        }
        WindowsFileSystemConfiguration other = (WindowsFileSystemConfiguration)obj;
        return Objects.equals(this.activeDirectoryId(), other.activeDirectoryId()) && Objects.equals(this.selfManagedActiveDirectoryConfiguration(), other.selfManagedActiveDirectoryConfiguration()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.remoteAdministrationEndpoint(), other.remoteAdministrationEndpoint()) && Objects.equals(this.preferredSubnetId(), other.preferredSubnetId()) && Objects.equals(this.preferredFileServerIp(), other.preferredFileServerIp()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && this.hasMaintenanceOperationsInProgress() == other.hasMaintenanceOperationsInProgress() && Objects.equals(this.maintenanceOperationsInProgressAsStrings(), other.maintenanceOperationsInProgressAsStrings()) && Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups()) && this.hasAliases() == other.hasAliases() && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.auditLogConfiguration(), other.auditLogConfiguration()) && Objects.equals(this.diskIopsConfiguration(), other.diskIopsConfiguration()) && Objects.equals(this.preferredFileServerIpv6(), other.preferredFileServerIpv6()) && Objects.equals(this.fsrmConfiguration(), other.fsrmConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"WindowsFileSystemConfiguration").add("ActiveDirectoryId", (Object)this.activeDirectoryId()).add("SelfManagedActiveDirectoryConfiguration", (Object)this.selfManagedActiveDirectoryConfiguration()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("RemoteAdministrationEndpoint", (Object)this.remoteAdministrationEndpoint()).add("PreferredSubnetId", (Object)this.preferredSubnetId()).add("PreferredFileServerIp", (Object)this.preferredFileServerIp()).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("MaintenanceOperationsInProgress", this.hasMaintenanceOperationsInProgress() ? this.maintenanceOperationsInProgressAsStrings() : null).add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).add("Aliases", this.hasAliases() ? this.aliases() : null).add("AuditLogConfiguration", (Object)this.auditLogConfiguration()).add("DiskIopsConfiguration", (Object)this.diskIopsConfiguration()).add("PreferredFileServerIpv6", (Object)this.preferredFileServerIpv6()).add("FsrmConfiguration", (Object)this.fsrmConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveDirectoryId": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryId()));
            }
            case "SelfManagedActiveDirectoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.selfManagedActiveDirectoryConfiguration()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "RemoteAdministrationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.remoteAdministrationEndpoint()));
            }
            case "PreferredSubnetId": {
                return Optional.ofNullable(clazz.cast(this.preferredSubnetId()));
            }
            case "PreferredFileServerIp": {
                return Optional.ofNullable(clazz.cast(this.preferredFileServerIp()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "MaintenanceOperationsInProgress": {
                return Optional.ofNullable(clazz.cast(this.maintenanceOperationsInProgressAsStrings()));
            }
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
            case "AuditLogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.auditLogConfiguration()));
            }
            case "DiskIopsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.diskIopsConfiguration()));
            }
            case "PreferredFileServerIpv6": {
                return Optional.ofNullable(clazz.cast(this.preferredFileServerIpv6()));
            }
            case "FsrmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fsrmConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActiveDirectoryId", ACTIVE_DIRECTORY_ID_FIELD);
        map.put("SelfManagedActiveDirectoryConfiguration", SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD);
        map.put("DeploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("RemoteAdministrationEndpoint", REMOTE_ADMINISTRATION_ENDPOINT_FIELD);
        map.put("PreferredSubnetId", PREFERRED_SUBNET_ID_FIELD);
        map.put("PreferredFileServerIp", PREFERRED_FILE_SERVER_IP_FIELD);
        map.put("ThroughputCapacity", THROUGHPUT_CAPACITY_FIELD);
        map.put("MaintenanceOperationsInProgress", MAINTENANCE_OPERATIONS_IN_PROGRESS_FIELD);
        map.put("WeeklyMaintenanceStartTime", WEEKLY_MAINTENANCE_START_TIME_FIELD);
        map.put("DailyAutomaticBackupStartTime", DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD);
        map.put("AutomaticBackupRetentionDays", AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD);
        map.put("CopyTagsToBackups", COPY_TAGS_TO_BACKUPS_FIELD);
        map.put("Aliases", ALIASES_FIELD);
        map.put("AuditLogConfiguration", AUDIT_LOG_CONFIGURATION_FIELD);
        map.put("DiskIopsConfiguration", DISK_IOPS_CONFIGURATION_FIELD);
        map.put("PreferredFileServerIpv6", PREFERRED_FILE_SERVER_IPV6_FIELD);
        map.put("FsrmConfiguration", FSRM_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WindowsFileSystemConfiguration, T> g) {
        return obj -> g.apply((WindowsFileSystemConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activeDirectoryId;
        private SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration;
        private String deploymentType;
        private String remoteAdministrationEndpoint;
        private String preferredSubnetId;
        private String preferredFileServerIp;
        private Integer throughputCapacity;
        private List<String> maintenanceOperationsInProgress = DefaultSdkAutoConstructList.getInstance();
        private String weeklyMaintenanceStartTime;
        private String dailyAutomaticBackupStartTime;
        private Integer automaticBackupRetentionDays;
        private Boolean copyTagsToBackups;
        private List<Alias> aliases = DefaultSdkAutoConstructList.getInstance();
        private WindowsAuditLogConfiguration auditLogConfiguration;
        private DiskIopsConfiguration diskIopsConfiguration;
        private String preferredFileServerIpv6;
        private WindowsFsrmConfiguration fsrmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowsFileSystemConfiguration model) {
            this.activeDirectoryId(model.activeDirectoryId);
            this.selfManagedActiveDirectoryConfiguration(model.selfManagedActiveDirectoryConfiguration);
            this.deploymentType(model.deploymentType);
            this.remoteAdministrationEndpoint(model.remoteAdministrationEndpoint);
            this.preferredSubnetId(model.preferredSubnetId);
            this.preferredFileServerIp(model.preferredFileServerIp);
            this.throughputCapacity(model.throughputCapacity);
            this.maintenanceOperationsInProgressWithStrings(model.maintenanceOperationsInProgress);
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.copyTagsToBackups(model.copyTagsToBackups);
            this.aliases(model.aliases);
            this.auditLogConfiguration(model.auditLogConfiguration);
            this.diskIopsConfiguration(model.diskIopsConfiguration);
            this.preferredFileServerIpv6(model.preferredFileServerIpv6);
            this.fsrmConfiguration(model.fsrmConfiguration);
        }

        public final String getActiveDirectoryId() {
            return this.activeDirectoryId;
        }

        public final void setActiveDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
        }

        @Override
        public final Builder activeDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
            return this;
        }

        public final SelfManagedActiveDirectoryAttributes.Builder getSelfManagedActiveDirectoryConfiguration() {
            return this.selfManagedActiveDirectoryConfiguration != null ? this.selfManagedActiveDirectoryConfiguration.toBuilder() : null;
        }

        public final void setSelfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes.BuilderImpl selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration.build() : null;
        }

        @Override
        public final Builder selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(WindowsDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getRemoteAdministrationEndpoint() {
            return this.remoteAdministrationEndpoint;
        }

        public final void setRemoteAdministrationEndpoint(String remoteAdministrationEndpoint) {
            this.remoteAdministrationEndpoint = remoteAdministrationEndpoint;
        }

        @Override
        public final Builder remoteAdministrationEndpoint(String remoteAdministrationEndpoint) {
            this.remoteAdministrationEndpoint = remoteAdministrationEndpoint;
            return this;
        }

        public final String getPreferredSubnetId() {
            return this.preferredSubnetId;
        }

        public final void setPreferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
        }

        @Override
        public final Builder preferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
            return this;
        }

        public final String getPreferredFileServerIp() {
            return this.preferredFileServerIp;
        }

        public final void setPreferredFileServerIp(String preferredFileServerIp) {
            this.preferredFileServerIp = preferredFileServerIp;
        }

        @Override
        public final Builder preferredFileServerIp(String preferredFileServerIp) {
            this.preferredFileServerIp = preferredFileServerIp;
            return this;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final Collection<String> getMaintenanceOperationsInProgress() {
            if (this.maintenanceOperationsInProgress instanceof SdkAutoConstructList) {
                return null;
            }
            return this.maintenanceOperationsInProgress;
        }

        public final void setMaintenanceOperationsInProgress(Collection<String> maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgress = FileSystemMaintenanceOperationsCopier.copy(maintenanceOperationsInProgress);
        }

        @Override
        public final Builder maintenanceOperationsInProgressWithStrings(Collection<String> maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgress = FileSystemMaintenanceOperationsCopier.copy(maintenanceOperationsInProgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceOperationsInProgressWithStrings(String ... maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgressWithStrings(Arrays.asList(maintenanceOperationsInProgress));
            return this;
        }

        @Override
        public final Builder maintenanceOperationsInProgress(Collection<FileSystemMaintenanceOperation> maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgress = FileSystemMaintenanceOperationsCopier.copyEnumToString(maintenanceOperationsInProgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceOperationsInProgress(FileSystemMaintenanceOperation ... maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgress(Arrays.asList(maintenanceOperationsInProgress));
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final List<Alias.Builder> getAliases() {
            List<Alias.Builder> result = AliasesCopier.copyToBuilder(this.aliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliases(Collection<Alias.BuilderImpl> aliases) {
            this.aliases = AliasesCopier.copyFromBuilder(aliases);
        }

        @Override
        public final Builder aliases(Collection<Alias> aliases) {
            this.aliases = AliasesCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Alias ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Consumer<Alias.Builder> ... aliases) {
            this.aliases(Stream.of(aliases).map(c -> (Alias)((Alias.Builder)Alias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final WindowsAuditLogConfiguration.Builder getAuditLogConfiguration() {
            return this.auditLogConfiguration != null ? this.auditLogConfiguration.toBuilder() : null;
        }

        public final void setAuditLogConfiguration(WindowsAuditLogConfiguration.BuilderImpl auditLogConfiguration) {
            this.auditLogConfiguration = auditLogConfiguration != null ? auditLogConfiguration.build() : null;
        }

        @Override
        public final Builder auditLogConfiguration(WindowsAuditLogConfiguration auditLogConfiguration) {
            this.auditLogConfiguration = auditLogConfiguration;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return this.diskIopsConfiguration != null ? this.diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final String getPreferredFileServerIpv6() {
            return this.preferredFileServerIpv6;
        }

        public final void setPreferredFileServerIpv6(String preferredFileServerIpv6) {
            this.preferredFileServerIpv6 = preferredFileServerIpv6;
        }

        @Override
        public final Builder preferredFileServerIpv6(String preferredFileServerIpv6) {
            this.preferredFileServerIpv6 = preferredFileServerIpv6;
            return this;
        }

        public final WindowsFsrmConfiguration.Builder getFsrmConfiguration() {
            return this.fsrmConfiguration != null ? this.fsrmConfiguration.toBuilder() : null;
        }

        public final void setFsrmConfiguration(WindowsFsrmConfiguration.BuilderImpl fsrmConfiguration) {
            this.fsrmConfiguration = fsrmConfiguration != null ? fsrmConfiguration.build() : null;
        }

        @Override
        public final Builder fsrmConfiguration(WindowsFsrmConfiguration fsrmConfiguration) {
            this.fsrmConfiguration = fsrmConfiguration;
            return this;
        }

        public WindowsFileSystemConfiguration build() {
            return new WindowsFileSystemConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WindowsFileSystemConfiguration> {
        public Builder activeDirectoryId(String var1);

        public Builder selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes var1);

        default public Builder selfManagedActiveDirectoryConfiguration(Consumer<SelfManagedActiveDirectoryAttributes.Builder> selfManagedActiveDirectoryConfiguration) {
            return this.selfManagedActiveDirectoryConfiguration((SelfManagedActiveDirectoryAttributes)((SelfManagedActiveDirectoryAttributes.Builder)SelfManagedActiveDirectoryAttributes.builder().applyMutation(selfManagedActiveDirectoryConfiguration)).build());
        }

        public Builder deploymentType(String var1);

        public Builder deploymentType(WindowsDeploymentType var1);

        public Builder remoteAdministrationEndpoint(String var1);

        public Builder preferredSubnetId(String var1);

        public Builder preferredFileServerIp(String var1);

        public Builder throughputCapacity(Integer var1);

        public Builder maintenanceOperationsInProgressWithStrings(Collection<String> var1);

        public Builder maintenanceOperationsInProgressWithStrings(String ... var1);

        public Builder maintenanceOperationsInProgress(Collection<FileSystemMaintenanceOperation> var1);

        public Builder maintenanceOperationsInProgress(FileSystemMaintenanceOperation ... var1);

        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder copyTagsToBackups(Boolean var1);

        public Builder aliases(Collection<Alias> var1);

        public Builder aliases(Alias ... var1);

        public Builder aliases(Consumer<Alias.Builder> ... var1);

        public Builder auditLogConfiguration(WindowsAuditLogConfiguration var1);

        default public Builder auditLogConfiguration(Consumer<WindowsAuditLogConfiguration.Builder> auditLogConfiguration) {
            return this.auditLogConfiguration((WindowsAuditLogConfiguration)((WindowsAuditLogConfiguration.Builder)WindowsAuditLogConfiguration.builder().applyMutation(auditLogConfiguration)).build());
        }

        public Builder diskIopsConfiguration(DiskIopsConfiguration var1);

        default public Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return this.diskIopsConfiguration((DiskIopsConfiguration)((DiskIopsConfiguration.Builder)DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration)).build());
        }

        public Builder preferredFileServerIpv6(String var1);

        public Builder fsrmConfiguration(WindowsFsrmConfiguration var1);

        default public Builder fsrmConfiguration(Consumer<WindowsFsrmConfiguration.Builder> fsrmConfiguration) {
            return this.fsrmConfiguration((WindowsFsrmConfiguration)((WindowsFsrmConfiguration.Builder)WindowsFsrmConfiguration.builder().applyMutation(fsrmConfiguration)).build());
        }
    }
}

