/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.DeleteVolumeOntapResponse;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.services.fsx.model.VolumeLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVolumeResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DeleteVolumeResponse> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(DeleteVolumeResponse.getter(DeleteVolumeResponse::volumeId)).setter(DeleteVolumeResponse.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(DeleteVolumeResponse.getter(DeleteVolumeResponse::lifecycleAsString)).setter(DeleteVolumeResponse.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<DeleteVolumeOntapResponse> ONTAP_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OntapResponse").getter(DeleteVolumeResponse.getter(DeleteVolumeResponse::ontapResponse)).setter(DeleteVolumeResponse.setter(Builder::ontapResponse)).constructor(DeleteVolumeOntapResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD, LIFECYCLE_FIELD, ONTAP_RESPONSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteVolumeResponse.memberNameToFieldInitializer();
    private final String volumeId;
    private final String lifecycle;
    private final DeleteVolumeOntapResponse ontapResponse;

    private DeleteVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volumeId = builder.volumeId;
        this.lifecycle = builder.lifecycle;
        this.ontapResponse = builder.ontapResponse;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final VolumeLifecycle lifecycle() {
        return VolumeLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final DeleteVolumeOntapResponse ontapResponse() {
        return this.ontapResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ontapResponse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVolumeResponse)) {
            return false;
        }
        DeleteVolumeResponse other = (DeleteVolumeResponse)((Object)obj);
        return Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.ontapResponse(), other.ontapResponse());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteVolumeResponse").add("VolumeId", (Object)this.volumeId()).add("Lifecycle", (Object)this.lifecycleAsString()).add("OntapResponse", (Object)this.ontapResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "OntapResponse": {
                return Optional.ofNullable(clazz.cast(this.ontapResponse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("OntapResponse", ONTAP_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVolumeResponse, T> g) {
        return obj -> g.apply((DeleteVolumeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private String volumeId;
        private String lifecycle;
        private DeleteVolumeOntapResponse ontapResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVolumeResponse model) {
            super(model);
            this.volumeId(model.volumeId);
            this.lifecycle(model.lifecycle);
            this.ontapResponse(model.ontapResponse);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(VolumeLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final DeleteVolumeOntapResponse.Builder getOntapResponse() {
            return this.ontapResponse != null ? this.ontapResponse.toBuilder() : null;
        }

        public final void setOntapResponse(DeleteVolumeOntapResponse.BuilderImpl ontapResponse) {
            this.ontapResponse = ontapResponse != null ? ontapResponse.build() : null;
        }

        @Override
        public final Builder ontapResponse(DeleteVolumeOntapResponse ontapResponse) {
            this.ontapResponse = ontapResponse;
            return this;
        }

        @Override
        public DeleteVolumeResponse build() {
            return new DeleteVolumeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteVolumeResponse> {
        public Builder volumeId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(VolumeLifecycle var1);

        public Builder ontapResponse(DeleteVolumeOntapResponse var1);

        default public Builder ontapResponse(Consumer<DeleteVolumeOntapResponse.Builder> ontapResponse) {
            return this.ontapResponse((DeleteVolumeOntapResponse)((DeleteVolumeOntapResponse.Builder)DeleteVolumeOntapResponse.builder().applyMutation(ontapResponse)).build());
        }
    }
}

