/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.fsx.model.Snapshot;

public class DescribeSnapshotsIterable
implements SdkIterable<DescribeSnapshotsResponse> {
    private final FSxClient client;
    private final DescribeSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSnapshotsIterable(FSxClient client, DescribeSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSnapshotsResponseFetcher();
    }

    public Iterator<DescribeSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Snapshot> snapshots() {
        Function<DescribeSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSnapshotsResponseFetcher
    implements SyncPageFetcher<DescribeSnapshotsResponse> {
        private DescribeSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSnapshotsResponse nextPage(DescribeSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotsIterable.this.client.describeSnapshots(DescribeSnapshotsIterable.this.firstRequest);
            }
            return DescribeSnapshotsIterable.this.client.describeSnapshots((DescribeSnapshotsRequest)((Object)DescribeSnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

