/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SecurityStyle {
    UNIX("UNIX"),
    NTFS("NTFS"),
    MIXED("MIXED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SecurityStyle> VALUE_MAP;
    private final String value;

    private SecurityStyle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecurityStyle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecurityStyle> knownValues() {
        EnumSet<SecurityStyle> knownValues = EnumSet.allOf(SecurityStyle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SecurityStyle.class, SecurityStyle::toString);
    }
}

