/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.AutoExportPolicy;
import software.amazon.awssdk.services.fsx.model.AutoImportPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DataRepositoryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DataRepositoryConfiguration> {
    private static final SdkField<AutoImportPolicy> AUTO_IMPORT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoImportPolicy").getter(S3DataRepositoryConfiguration.getter(S3DataRepositoryConfiguration::autoImportPolicy)).setter(S3DataRepositoryConfiguration.setter(Builder::autoImportPolicy)).constructor(AutoImportPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImportPolicy").build()}).build();
    private static final SdkField<AutoExportPolicy> AUTO_EXPORT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoExportPolicy").getter(S3DataRepositoryConfiguration.getter(S3DataRepositoryConfiguration::autoExportPolicy)).setter(S3DataRepositoryConfiguration.setter(Builder::autoExportPolicy)).constructor(AutoExportPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoExportPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_IMPORT_POLICY_FIELD, AUTO_EXPORT_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3DataRepositoryConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutoImportPolicy autoImportPolicy;
    private final AutoExportPolicy autoExportPolicy;

    private S3DataRepositoryConfiguration(BuilderImpl builder) {
        this.autoImportPolicy = builder.autoImportPolicy;
        this.autoExportPolicy = builder.autoExportPolicy;
    }

    public final AutoImportPolicy autoImportPolicy() {
        return this.autoImportPolicy;
    }

    public final AutoExportPolicy autoExportPolicy() {
        return this.autoExportPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoImportPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoExportPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataRepositoryConfiguration)) {
            return false;
        }
        S3DataRepositoryConfiguration other = (S3DataRepositoryConfiguration)obj;
        return Objects.equals(this.autoImportPolicy(), other.autoImportPolicy()) && Objects.equals(this.autoExportPolicy(), other.autoExportPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"S3DataRepositoryConfiguration").add("AutoImportPolicy", (Object)this.autoImportPolicy()).add("AutoExportPolicy", (Object)this.autoExportPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoImportPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoImportPolicy()));
            }
            case "AutoExportPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoExportPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoImportPolicy", AUTO_IMPORT_POLICY_FIELD);
        map.put("AutoExportPolicy", AUTO_EXPORT_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3DataRepositoryConfiguration, T> g) {
        return obj -> g.apply((S3DataRepositoryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoImportPolicy autoImportPolicy;
        private AutoExportPolicy autoExportPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataRepositoryConfiguration model) {
            this.autoImportPolicy(model.autoImportPolicy);
            this.autoExportPolicy(model.autoExportPolicy);
        }

        public final AutoImportPolicy.Builder getAutoImportPolicy() {
            return this.autoImportPolicy != null ? this.autoImportPolicy.toBuilder() : null;
        }

        public final void setAutoImportPolicy(AutoImportPolicy.BuilderImpl autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy != null ? autoImportPolicy.build() : null;
        }

        @Override
        public final Builder autoImportPolicy(AutoImportPolicy autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
            return this;
        }

        public final AutoExportPolicy.Builder getAutoExportPolicy() {
            return this.autoExportPolicy != null ? this.autoExportPolicy.toBuilder() : null;
        }

        public final void setAutoExportPolicy(AutoExportPolicy.BuilderImpl autoExportPolicy) {
            this.autoExportPolicy = autoExportPolicy != null ? autoExportPolicy.build() : null;
        }

        @Override
        public final Builder autoExportPolicy(AutoExportPolicy autoExportPolicy) {
            this.autoExportPolicy = autoExportPolicy;
            return this;
        }

        public S3DataRepositoryConfiguration build() {
            return new S3DataRepositoryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DataRepositoryConfiguration> {
        public Builder autoImportPolicy(AutoImportPolicy var1);

        default public Builder autoImportPolicy(Consumer<AutoImportPolicy.Builder> autoImportPolicy) {
            return this.autoImportPolicy((AutoImportPolicy)((AutoImportPolicy.Builder)AutoImportPolicy.builder().applyMutation(autoImportPolicy)).build());
        }

        public Builder autoExportPolicy(AutoExportPolicy var1);

        default public Builder autoExportPolicy(Consumer<AutoExportPolicy.Builder> autoExportPolicy) {
            return this.autoExportPolicy((AutoExportPolicy)((AutoExportPolicy.Builder)AutoExportPolicy.builder().applyMutation(autoExportPolicy)).build());
        }
    }
}

