/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.S3AccessPointVpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3AccessPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3AccessPoint> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(S3AccessPoint.getter(S3AccessPoint::resourceARN)).setter(S3AccessPoint.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(S3AccessPoint.getter(S3AccessPoint::alias)).setter(S3AccessPoint.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<S3AccessPointVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(S3AccessPoint.getter(S3AccessPoint::vpcConfiguration)).setter(S3AccessPoint.setter(Builder::vpcConfiguration)).constructor(S3AccessPointVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, ALIAS_FIELD, VPC_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3AccessPoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceARN;
    private final String alias;
    private final S3AccessPointVpcConfiguration vpcConfiguration;

    private S3AccessPoint(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.alias = builder.alias;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public final String alias() {
        return this.alias;
    }

    public final S3AccessPointVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessPoint)) {
            return false;
        }
        S3AccessPoint other = (S3AccessPoint)obj;
        return Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"S3AccessPoint").add("ResourceARN", (Object)this.resourceARN()).add("Alias", (Object)this.alias()).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceARN", RESOURCE_ARN_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3AccessPoint, T> g) {
        return obj -> g.apply((S3AccessPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceARN;
        private String alias;
        private S3AccessPointVpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessPoint model) {
            this.resourceARN(model.resourceARN);
            this.alias(model.alias);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final S3AccessPointVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(S3AccessPointVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(S3AccessPointVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public S3AccessPoint build() {
            return new S3AccessPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3AccessPoint> {
        public Builder resourceARN(String var1);

        public Builder alias(String var1);

        public Builder vpcConfiguration(S3AccessPointVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<S3AccessPointVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((S3AccessPointVpcConfiguration)((S3AccessPointVpcConfiguration.Builder)S3AccessPointVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

