/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.AutoExportPolicy;
import software.amazon.awssdk.services.fsx.model.NfsVersion;
import software.amazon.awssdk.services.fsx.model.RepositoryDnsIpsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NFSDataRepositoryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NFSDataRepositoryConfiguration> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(NFSDataRepositoryConfiguration.getter(NFSDataRepositoryConfiguration::versionAsString)).setter(NFSDataRepositoryConfiguration.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIps").getter(NFSDataRepositoryConfiguration.getter(NFSDataRepositoryConfiguration::dnsIps)).setter(NFSDataRepositoryConfiguration.setter(Builder::dnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoExportPolicy> AUTO_EXPORT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoExportPolicy").getter(NFSDataRepositoryConfiguration.getter(NFSDataRepositoryConfiguration::autoExportPolicy)).setter(NFSDataRepositoryConfiguration.setter(Builder::autoExportPolicy)).constructor(AutoExportPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoExportPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, DNS_IPS_FIELD, AUTO_EXPORT_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NFSDataRepositoryConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String version;
    private final List<String> dnsIps;
    private final AutoExportPolicy autoExportPolicy;

    private NFSDataRepositoryConfiguration(BuilderImpl builder) {
        this.version = builder.version;
        this.dnsIps = builder.dnsIps;
        this.autoExportPolicy = builder.autoExportPolicy;
    }

    public final NfsVersion version() {
        return NfsVersion.fromValue(this.version);
    }

    public final String versionAsString() {
        return this.version;
    }

    public final boolean hasDnsIps() {
        return this.dnsIps != null && !(this.dnsIps instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIps() {
        return this.dnsIps;
    }

    public final AutoExportPolicy autoExportPolicy() {
        return this.autoExportPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIps() ? this.dnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoExportPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NFSDataRepositoryConfiguration)) {
            return false;
        }
        NFSDataRepositoryConfiguration other = (NFSDataRepositoryConfiguration)obj;
        return Objects.equals(this.versionAsString(), other.versionAsString()) && this.hasDnsIps() == other.hasDnsIps() && Objects.equals(this.dnsIps(), other.dnsIps()) && Objects.equals(this.autoExportPolicy(), other.autoExportPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"NFSDataRepositoryConfiguration").add("Version", (Object)this.versionAsString()).add("DnsIps", this.hasDnsIps() ? this.dnsIps() : null).add("AutoExportPolicy", (Object)this.autoExportPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.versionAsString()));
            }
            case "DnsIps": {
                return Optional.ofNullable(clazz.cast(this.dnsIps()));
            }
            case "AutoExportPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoExportPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Version", VERSION_FIELD);
        map.put("DnsIps", DNS_IPS_FIELD);
        map.put("AutoExportPolicy", AUTO_EXPORT_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NFSDataRepositoryConfiguration, T> g) {
        return obj -> g.apply((NFSDataRepositoryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private List<String> dnsIps = DefaultSdkAutoConstructList.getInstance();
        private AutoExportPolicy autoExportPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(NFSDataRepositoryConfiguration model) {
            this.version(model.version);
            this.dnsIps(model.dnsIps);
            this.autoExportPolicy(model.autoExportPolicy);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public final Builder version(NfsVersion version) {
            this.version(version == null ? null : version.toString());
            return this;
        }

        public final Collection<String> getDnsIps() {
            if (this.dnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIps;
        }

        public final void setDnsIps(Collection<String> dnsIps) {
            this.dnsIps = RepositoryDnsIpsCopier.copy(dnsIps);
        }

        @Override
        public final Builder dnsIps(Collection<String> dnsIps) {
            this.dnsIps = RepositoryDnsIpsCopier.copy(dnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIps(String ... dnsIps) {
            this.dnsIps(Arrays.asList(dnsIps));
            return this;
        }

        public final AutoExportPolicy.Builder getAutoExportPolicy() {
            return this.autoExportPolicy != null ? this.autoExportPolicy.toBuilder() : null;
        }

        public final void setAutoExportPolicy(AutoExportPolicy.BuilderImpl autoExportPolicy) {
            this.autoExportPolicy = autoExportPolicy != null ? autoExportPolicy.build() : null;
        }

        @Override
        public final Builder autoExportPolicy(AutoExportPolicy autoExportPolicy) {
            this.autoExportPolicy = autoExportPolicy;
            return this;
        }

        public NFSDataRepositoryConfiguration build() {
            return new NFSDataRepositoryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NFSDataRepositoryConfiguration> {
        public Builder version(String var1);

        public Builder version(NfsVersion var1);

        public Builder dnsIps(Collection<String> var1);

        public Builder dnsIps(String ... var1);

        public Builder autoExportPolicy(AutoExportPolicy var1);

        default public Builder autoExportPolicy(Consumer<AutoExportPolicy.Builder> autoExportPolicy) {
            return this.autoExportPolicy((AutoExportPolicy)((AutoExportPolicy.Builder)AutoExportPolicy.builder().applyMutation(autoExportPolicy)).build());
        }
    }
}

