/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.NfsVersion;
import software.amazon.awssdk.services.fsx.model.RepositoryDnsIpsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileCacheNFSConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileCacheNFSConfiguration> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(FileCacheNFSConfiguration.getter(FileCacheNFSConfiguration::versionAsString)).setter(FileCacheNFSConfiguration.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIps").getter(FileCacheNFSConfiguration.getter(FileCacheNFSConfiguration::dnsIps)).setter(FileCacheNFSConfiguration.setter(Builder::dnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, DNS_IPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FileCacheNFSConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String version;
    private final List<String> dnsIps;

    private FileCacheNFSConfiguration(BuilderImpl builder) {
        this.version = builder.version;
        this.dnsIps = builder.dnsIps;
    }

    public final NfsVersion version() {
        return NfsVersion.fromValue(this.version);
    }

    public final String versionAsString() {
        return this.version;
    }

    public final boolean hasDnsIps() {
        return this.dnsIps != null && !(this.dnsIps instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIps() {
        return this.dnsIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIps() ? this.dnsIps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileCacheNFSConfiguration)) {
            return false;
        }
        FileCacheNFSConfiguration other = (FileCacheNFSConfiguration)obj;
        return Objects.equals(this.versionAsString(), other.versionAsString()) && this.hasDnsIps() == other.hasDnsIps() && Objects.equals(this.dnsIps(), other.dnsIps());
    }

    public final String toString() {
        return ToString.builder((String)"FileCacheNFSConfiguration").add("Version", (Object)this.versionAsString()).add("DnsIps", this.hasDnsIps() ? this.dnsIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.versionAsString()));
            }
            case "DnsIps": {
                return Optional.ofNullable(clazz.cast(this.dnsIps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Version", VERSION_FIELD);
        map.put("DnsIps", DNS_IPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileCacheNFSConfiguration, T> g) {
        return obj -> g.apply((FileCacheNFSConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private List<String> dnsIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FileCacheNFSConfiguration model) {
            this.version(model.version);
            this.dnsIps(model.dnsIps);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public final Builder version(NfsVersion version) {
            this.version(version == null ? null : version.toString());
            return this;
        }

        public final Collection<String> getDnsIps() {
            if (this.dnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIps;
        }

        public final void setDnsIps(Collection<String> dnsIps) {
            this.dnsIps = RepositoryDnsIpsCopier.copy(dnsIps);
        }

        @Override
        public final Builder dnsIps(Collection<String> dnsIps) {
            this.dnsIps = RepositoryDnsIpsCopier.copy(dnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIps(String ... dnsIps) {
            this.dnsIps(Arrays.asList(dnsIps));
            return this;
        }

        public FileCacheNFSConfiguration build() {
            return new FileCacheNFSConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileCacheNFSConfiguration> {
        public Builder version(String var1);

        public Builder version(NfsVersion var1);

        public Builder dnsIps(Collection<String> var1);

        public Builder dnsIps(String ... var1);
    }
}

