/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.BackupLifecycle;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteBackupResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DeleteBackupResponse> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupId").getter(DeleteBackupResponse.getter(DeleteBackupResponse::backupId)).setter(DeleteBackupResponse.setter(Builder::backupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(DeleteBackupResponse.getter(DeleteBackupResponse::lifecycleAsString)).setter(DeleteBackupResponse.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD, LIFECYCLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteBackupResponse.memberNameToFieldInitializer();
    private final String backupId;
    private final String lifecycle;

    private DeleteBackupResponse(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.lifecycle = builder.lifecycle;
    }

    public final String backupId() {
        return this.backupId;
    }

    public final BackupLifecycle lifecycle() {
        return BackupLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBackupResponse)) {
            return false;
        }
        DeleteBackupResponse other = (DeleteBackupResponse)((Object)obj);
        return Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteBackupResponse").add("BackupId", (Object)this.backupId()).add("Lifecycle", (Object)this.lifecycleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BackupId", BACKUP_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBackupResponse, T> g) {
        return obj -> g.apply((DeleteBackupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private String backupId;
        private String lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBackupResponse model) {
            super(model);
            this.backupId(model.backupId);
            this.lifecycle(model.lifecycle);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(BackupLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        @Override
        public DeleteBackupResponse build() {
            return new DeleteBackupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteBackupResponse> {
        public Builder backupId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(BackupLifecycle var1);
    }
}

