/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenZFSUserOrGroupQuota
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenZFSUserOrGroupQuota> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(OpenZFSUserOrGroupQuota.getter(OpenZFSUserOrGroupQuota::typeAsString)).setter(OpenZFSUserOrGroupQuota.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Id").getter(OpenZFSUserOrGroupQuota.getter(OpenZFSUserOrGroupQuota::id)).setter(OpenZFSUserOrGroupQuota.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_QUOTA_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageCapacityQuotaGiB").getter(OpenZFSUserOrGroupQuota.getter(OpenZFSUserOrGroupQuota::storageCapacityQuotaGiB)).setter(OpenZFSUserOrGroupQuota.setter(Builder::storageCapacityQuotaGiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityQuotaGiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD, STORAGE_CAPACITY_QUOTA_GIB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpenZFSUserOrGroupQuota.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Integer id;
    private final Integer storageCapacityQuotaGiB;

    private OpenZFSUserOrGroupQuota(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.storageCapacityQuotaGiB = builder.storageCapacityQuotaGiB;
    }

    public final OpenZFSQuotaType type() {
        return OpenZFSQuotaType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer id() {
        return this.id;
    }

    public final Integer storageCapacityQuotaGiB() {
        return this.storageCapacityQuotaGiB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacityQuotaGiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSUserOrGroupQuota)) {
            return false;
        }
        OpenZFSUserOrGroupQuota other = (OpenZFSUserOrGroupQuota)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.storageCapacityQuotaGiB(), other.storageCapacityQuotaGiB());
    }

    public final String toString() {
        return ToString.builder((String)"OpenZFSUserOrGroupQuota").add("Type", (Object)this.typeAsString()).add("Id", (Object)this.id()).add("StorageCapacityQuotaGiB", (Object)this.storageCapacityQuotaGiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "StorageCapacityQuotaGiB": {
                return Optional.ofNullable(clazz.cast(this.storageCapacityQuotaGiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("StorageCapacityQuotaGiB", STORAGE_CAPACITY_QUOTA_GIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSUserOrGroupQuota, T> g) {
        return obj -> g.apply((OpenZFSUserOrGroupQuota)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Integer id;
        private Integer storageCapacityQuotaGiB;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSUserOrGroupQuota model) {
            this.type(model.type);
            this.id(model.id);
            this.storageCapacityQuotaGiB(model.storageCapacityQuotaGiB);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OpenZFSQuotaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final Integer getStorageCapacityQuotaGiB() {
            return this.storageCapacityQuotaGiB;
        }

        public final void setStorageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
        }

        @Override
        public final Builder storageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
            return this;
        }

        public OpenZFSUserOrGroupQuota build() {
            return new OpenZFSUserOrGroupQuota(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenZFSUserOrGroupQuota> {
        public Builder type(String var1);

        public Builder type(OpenZFSQuotaType var1);

        public Builder id(Integer var1);

        public Builder storageCapacityQuotaGiB(Integer var1);
    }
}

