/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse;

public class DescribeFileSystemAliasesPublisher
implements SdkPublisher<DescribeFileSystemAliasesResponse> {
    private final FSxAsyncClient client;
    private final DescribeFileSystemAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFileSystemAliasesPublisher(FSxAsyncClient client, DescribeFileSystemAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFileSystemAliasesPublisher(FSxAsyncClient client, DescribeFileSystemAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFileSystemAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFileSystemAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeFileSystemAliasesResponseFetcher
    implements AsyncPageFetcher<DescribeFileSystemAliasesResponse> {
        private DescribeFileSystemAliasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFileSystemAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFileSystemAliasesResponse> nextPage(DescribeFileSystemAliasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFileSystemAliasesPublisher.this.client.describeFileSystemAliases(DescribeFileSystemAliasesPublisher.this.firstRequest);
            }
            return DescribeFileSystemAliasesPublisher.this.client.describeFileSystemAliases((DescribeFileSystemAliasesRequest)((Object)DescribeFileSystemAliasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

