/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpenZFSCopyStrategy {
    CLONE("CLONE"),
    FULL_COPY("FULL_COPY"),
    INCREMENTAL_COPY("INCREMENTAL_COPY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpenZFSCopyStrategy> VALUE_MAP;
    private final String value;

    private OpenZFSCopyStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpenZFSCopyStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpenZFSCopyStrategy> knownValues() {
        EnumSet<OpenZFSCopyStrategy> knownValues = EnumSet.allOf(OpenZFSCopyStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpenZFSCopyStrategy.class, OpenZFSCopyStrategy::toString);
    }
}

