/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetadataConfigurationMode {
    AUTOMATIC("AUTOMATIC"),
    USER_PROVISIONED("USER_PROVISIONED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetadataConfigurationMode> VALUE_MAP;
    private final String value;

    private MetadataConfigurationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetadataConfigurationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetadataConfigurationMode> knownValues() {
        EnumSet<MetadataConfigurationMode> knownValues = EnumSet.allOf(MetadataConfigurationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetadataConfigurationMode.class, MetadataConfigurationMode::toString);
    }
}

