/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.freetier.FreeTierAsyncClient;
import software.amazon.awssdk.services.freetier.internal.UserAgentUtils;
import software.amazon.awssdk.services.freetier.model.ActivitySummary;
import software.amazon.awssdk.services.freetier.model.ListAccountActivitiesRequest;
import software.amazon.awssdk.services.freetier.model.ListAccountActivitiesResponse;

public class ListAccountActivitiesPublisher
implements SdkPublisher<ListAccountActivitiesResponse> {
    private final FreeTierAsyncClient client;
    private final ListAccountActivitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountActivitiesPublisher(FreeTierAsyncClient client, ListAccountActivitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountActivitiesPublisher(FreeTierAsyncClient client, ListAccountActivitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountActivitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountActivitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActivitySummary> activities() {
        Function<ListAccountActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.activities() != null) {
                return response.activities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountActivitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountActivitiesResponseFetcher
    implements AsyncPageFetcher<ListAccountActivitiesResponse> {
        private ListAccountActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountActivitiesResponse> nextPage(ListAccountActivitiesResponse previousPage) {
            if (previousPage == null) {
                return ListAccountActivitiesPublisher.this.client.listAccountActivities(ListAccountActivitiesPublisher.this.firstRequest);
            }
            return ListAccountActivitiesPublisher.this.client.listAccountActivities((ListAccountActivitiesRequest)((Object)ListAccountActivitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

