/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.freetier.model.AccountPlanStatus;
import software.amazon.awssdk.services.freetier.model.AccountPlanType;
import software.amazon.awssdk.services.freetier.model.FreeTierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeAccountPlanResponse
extends FreeTierResponse
implements ToCopyableBuilder<Builder, UpgradeAccountPlanResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(UpgradeAccountPlanResponse.getter(UpgradeAccountPlanResponse::accountId)).setter(UpgradeAccountPlanResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ACCOUNT_PLAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountPlanType").getter(UpgradeAccountPlanResponse.getter(UpgradeAccountPlanResponse::accountPlanTypeAsString)).setter(UpgradeAccountPlanResponse.setter(Builder::accountPlanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPlanType").build()}).build();
    private static final SdkField<String> ACCOUNT_PLAN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountPlanStatus").getter(UpgradeAccountPlanResponse.getter(UpgradeAccountPlanResponse::accountPlanStatusAsString)).setter(UpgradeAccountPlanResponse.setter(Builder::accountPlanStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPlanStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ACCOUNT_PLAN_TYPE_FIELD, ACCOUNT_PLAN_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpgradeAccountPlanResponse.memberNameToFieldInitializer();
    private final String accountId;
    private final String accountPlanType;
    private final String accountPlanStatus;

    private UpgradeAccountPlanResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.accountPlanType = builder.accountPlanType;
        this.accountPlanStatus = builder.accountPlanStatus;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AccountPlanType accountPlanType() {
        return AccountPlanType.fromValue(this.accountPlanType);
    }

    public final String accountPlanTypeAsString() {
        return this.accountPlanType;
    }

    public final AccountPlanStatus accountPlanStatus() {
        return AccountPlanStatus.fromValue(this.accountPlanStatus);
    }

    public final String accountPlanStatusAsString() {
        return this.accountPlanStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountPlanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountPlanStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeAccountPlanResponse)) {
            return false;
        }
        UpgradeAccountPlanResponse other = (UpgradeAccountPlanResponse)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.accountPlanTypeAsString(), other.accountPlanTypeAsString()) && Objects.equals(this.accountPlanStatusAsString(), other.accountPlanStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpgradeAccountPlanResponse").add("AccountId", (Object)this.accountId()).add("AccountPlanType", (Object)this.accountPlanTypeAsString()).add("AccountPlanStatus", (Object)this.accountPlanStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "accountPlanType": {
                return Optional.ofNullable(clazz.cast(this.accountPlanTypeAsString()));
            }
            case "accountPlanStatus": {
                return Optional.ofNullable(clazz.cast(this.accountPlanStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("accountPlanType", ACCOUNT_PLAN_TYPE_FIELD);
        map.put("accountPlanStatus", ACCOUNT_PLAN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpgradeAccountPlanResponse, T> g) {
        return obj -> g.apply((UpgradeAccountPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FreeTierResponse.BuilderImpl
    implements Builder {
        private String accountId;
        private String accountPlanType;
        private String accountPlanStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeAccountPlanResponse model) {
            super(model);
            this.accountId(model.accountId);
            this.accountPlanType(model.accountPlanType);
            this.accountPlanStatus(model.accountPlanStatus);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccountPlanType() {
            return this.accountPlanType;
        }

        public final void setAccountPlanType(String accountPlanType) {
            this.accountPlanType = accountPlanType;
        }

        @Override
        public final Builder accountPlanType(String accountPlanType) {
            this.accountPlanType = accountPlanType;
            return this;
        }

        @Override
        public final Builder accountPlanType(AccountPlanType accountPlanType) {
            this.accountPlanType(accountPlanType == null ? null : accountPlanType.toString());
            return this;
        }

        public final String getAccountPlanStatus() {
            return this.accountPlanStatus;
        }

        public final void setAccountPlanStatus(String accountPlanStatus) {
            this.accountPlanStatus = accountPlanStatus;
        }

        @Override
        public final Builder accountPlanStatus(String accountPlanStatus) {
            this.accountPlanStatus = accountPlanStatus;
            return this;
        }

        @Override
        public final Builder accountPlanStatus(AccountPlanStatus accountPlanStatus) {
            this.accountPlanStatus(accountPlanStatus == null ? null : accountPlanStatus.toString());
            return this;
        }

        @Override
        public UpgradeAccountPlanResponse build() {
            return new UpgradeAccountPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FreeTierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpgradeAccountPlanResponse> {
        public Builder accountId(String var1);

        public Builder accountPlanType(String var1);

        public Builder accountPlanType(AccountPlanType var1);

        public Builder accountPlanStatus(String var1);

        public Builder accountPlanStatus(AccountPlanStatus var1);
    }
}

