/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.freetier.model.CurrencyCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonetaryAmount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonetaryAmount> {
    private static final SdkField<Double> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("amount").getter(MonetaryAmount.getter(MonetaryAmount::amount)).setter(MonetaryAmount.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(MonetaryAmount.getter(MonetaryAmount::unitAsString)).setter(MonetaryAmount.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonetaryAmount.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double amount;
    private final String unit;

    private MonetaryAmount(BuilderImpl builder) {
        this.amount = builder.amount;
        this.unit = builder.unit;
    }

    public final Double amount() {
        return this.amount;
    }

    public final CurrencyCode unit() {
        return CurrencyCode.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonetaryAmount)) {
            return false;
        }
        MonetaryAmount other = (MonetaryAmount)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MonetaryAmount").add("Amount", (Object)this.amount()).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amount", AMOUNT_FIELD);
        map.put("unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonetaryAmount, T> g) {
        return obj -> g.apply((MonetaryAmount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double amount;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MonetaryAmount model) {
            this.amount(model.amount);
            this.unit(model.unit);
        }

        public final Double getAmount() {
            return this.amount;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(CurrencyCode unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public MonetaryAmount build() {
            return new MonetaryAmount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonetaryAmount> {
        public Builder amount(Double var1);

        public Builder unit(String var1);

        public Builder unit(CurrencyCode var1);
    }
}

