/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.freetier.model.ActivityStatus;
import software.amazon.awssdk.services.freetier.model.FilterActivityStatusesCopier;
import software.amazon.awssdk.services.freetier.model.FreeTierRequest;
import software.amazon.awssdk.services.freetier.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountActivitiesRequest
extends FreeTierRequest
implements ToCopyableBuilder<Builder, ListAccountActivitiesRequest> {
    private static final SdkField<List<String>> FILTER_ACTIVITY_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filterActivityStatuses").getter(ListAccountActivitiesRequest.getter(ListAccountActivitiesRequest::filterActivityStatusesAsStrings)).setter(ListAccountActivitiesRequest.setter(Builder::filterActivityStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterActivityStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccountActivitiesRequest.getter(ListAccountActivitiesRequest::nextToken)).setter(ListAccountActivitiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAccountActivitiesRequest.getter(ListAccountActivitiesRequest::maxResults)).setter(ListAccountActivitiesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("languageCode").getter(ListAccountActivitiesRequest.getter(ListAccountActivitiesRequest::languageCodeAsString)).setter(ListAccountActivitiesRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ACTIVITY_STATUSES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LANGUAGE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccountActivitiesRequest.memberNameToFieldInitializer();
    private final List<String> filterActivityStatuses;
    private final String nextToken;
    private final Integer maxResults;
    private final String languageCode;

    private ListAccountActivitiesRequest(BuilderImpl builder) {
        super(builder);
        this.filterActivityStatuses = builder.filterActivityStatuses;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.languageCode = builder.languageCode;
    }

    public final List<ActivityStatus> filterActivityStatuses() {
        return FilterActivityStatusesCopier.copyStringToEnum(this.filterActivityStatuses);
    }

    public final boolean hasFilterActivityStatuses() {
        return this.filterActivityStatuses != null && !(this.filterActivityStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> filterActivityStatusesAsStrings() {
        return this.filterActivityStatuses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterActivityStatuses() ? this.filterActivityStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountActivitiesRequest)) {
            return false;
        }
        ListAccountActivitiesRequest other = (ListAccountActivitiesRequest)((Object)obj);
        return this.hasFilterActivityStatuses() == other.hasFilterActivityStatuses() && Objects.equals(this.filterActivityStatusesAsStrings(), other.filterActivityStatusesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccountActivitiesRequest").add("FilterActivityStatuses", this.hasFilterActivityStatuses() ? this.filterActivityStatusesAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("LanguageCode", (Object)this.languageCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterActivityStatuses": {
                return Optional.ofNullable(clazz.cast(this.filterActivityStatusesAsStrings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "languageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterActivityStatuses", FILTER_ACTIVITY_STATUSES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("languageCode", LANGUAGE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountActivitiesRequest, T> g) {
        return obj -> g.apply((ListAccountActivitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FreeTierRequest.BuilderImpl
    implements Builder {
        private List<String> filterActivityStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountActivitiesRequest model) {
            super(model);
            this.filterActivityStatusesWithStrings(model.filterActivityStatuses);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.languageCode(model.languageCode);
        }

        public final Collection<String> getFilterActivityStatuses() {
            if (this.filterActivityStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterActivityStatuses;
        }

        public final void setFilterActivityStatuses(Collection<String> filterActivityStatuses) {
            this.filterActivityStatuses = FilterActivityStatusesCopier.copy(filterActivityStatuses);
        }

        @Override
        public final Builder filterActivityStatusesWithStrings(Collection<String> filterActivityStatuses) {
            this.filterActivityStatuses = FilterActivityStatusesCopier.copy(filterActivityStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterActivityStatusesWithStrings(String ... filterActivityStatuses) {
            this.filterActivityStatusesWithStrings(Arrays.asList(filterActivityStatuses));
            return this;
        }

        @Override
        public final Builder filterActivityStatuses(Collection<ActivityStatus> filterActivityStatuses) {
            this.filterActivityStatuses = FilterActivityStatusesCopier.copyEnumToString(filterActivityStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterActivityStatuses(ActivityStatus ... filterActivityStatuses) {
            this.filterActivityStatuses(Arrays.asList(filterActivityStatuses));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountActivitiesRequest build() {
            return new ListAccountActivitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FreeTierRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountActivitiesRequest> {
        public Builder filterActivityStatusesWithStrings(Collection<String> var1);

        public Builder filterActivityStatusesWithStrings(String ... var1);

        public Builder filterActivityStatuses(Collection<ActivityStatus> var1);

        public Builder filterActivityStatuses(ActivityStatus ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

