/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.freetier.model.FreeTierRequest;
import software.amazon.awssdk.services.freetier.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountActivityRequest
extends FreeTierRequest
implements ToCopyableBuilder<Builder, GetAccountActivityRequest> {
    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activityId").getter(GetAccountActivityRequest.getter(GetAccountActivityRequest::activityId)).setter(GetAccountActivityRequest.setter(Builder::activityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("languageCode").getter(GetAccountActivityRequest.getter(GetAccountActivityRequest::languageCodeAsString)).setter(GetAccountActivityRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ID_FIELD, LANGUAGE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccountActivityRequest.memberNameToFieldInitializer();
    private final String activityId;
    private final String languageCode;

    private GetAccountActivityRequest(BuilderImpl builder) {
        super(builder);
        this.activityId = builder.activityId;
        this.languageCode = builder.languageCode;
    }

    public final String activityId() {
        return this.activityId;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountActivityRequest)) {
            return false;
        }
        GetAccountActivityRequest other = (GetAccountActivityRequest)((Object)obj);
        return Objects.equals(this.activityId(), other.activityId()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountActivityRequest").add("ActivityId", (Object)this.activityId()).add("LanguageCode", (Object)this.languageCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activityId": {
                return Optional.ofNullable(clazz.cast(this.activityId()));
            }
            case "languageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("activityId", ACTIVITY_ID_FIELD);
        map.put("languageCode", LANGUAGE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountActivityRequest, T> g) {
        return obj -> g.apply((GetAccountActivityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FreeTierRequest.BuilderImpl
    implements Builder {
        private String activityId;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountActivityRequest model) {
            super(model);
            this.activityId(model.activityId);
            this.languageCode(model.languageCode);
        }

        public final String getActivityId() {
            return this.activityId;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAccountActivityRequest build() {
            return new GetAccountActivityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FreeTierRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountActivityRequest> {
        public Builder activityId(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

