/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.freetier.FreeTierAsyncClient;
import software.amazon.awssdk.services.freetier.internal.UserAgentUtils;
import software.amazon.awssdk.services.freetier.model.FreeTierUsage;
import software.amazon.awssdk.services.freetier.model.GetFreeTierUsageRequest;
import software.amazon.awssdk.services.freetier.model.GetFreeTierUsageResponse;

public class GetFreeTierUsagePublisher
implements SdkPublisher<GetFreeTierUsageResponse> {
    private final FreeTierAsyncClient client;
    private final GetFreeTierUsageRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFreeTierUsagePublisher(FreeTierAsyncClient client, GetFreeTierUsageRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFreeTierUsagePublisher(FreeTierAsyncClient client, GetFreeTierUsageRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFreeTierUsageResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFreeTierUsageResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FreeTierUsage> freeTierUsages() {
        Function<GetFreeTierUsageResponse, Iterator> getIterator = response -> {
            if (response != null && response.freeTierUsages() != null) {
                return response.freeTierUsages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetFreeTierUsageResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetFreeTierUsageResponseFetcher
    implements AsyncPageFetcher<GetFreeTierUsageResponse> {
        private GetFreeTierUsageResponseFetcher() {
        }

        public boolean hasNextPage(GetFreeTierUsageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFreeTierUsageResponse> nextPage(GetFreeTierUsageResponse previousPage) {
            if (previousPage == null) {
                return GetFreeTierUsagePublisher.this.client.getFreeTierUsage(GetFreeTierUsagePublisher.this.firstRequest);
            }
            return GetFreeTierUsagePublisher.this.client.getFreeTierUsage((GetFreeTierUsageRequest)((Object)GetFreeTierUsagePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

