/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetListsMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.GetListsMetadataResponse;

public class GetListsMetadataIterable
implements SdkIterable<GetListsMetadataResponse> {
    private final FraudDetectorClient client;
    private final GetListsMetadataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetListsMetadataIterable(FraudDetectorClient client, GetListsMetadataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetListsMetadataResponseFetcher();
    }

    public Iterator<GetListsMetadataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetListsMetadataResponseFetcher
    implements SyncPageFetcher<GetListsMetadataResponse> {
        private GetListsMetadataResponseFetcher() {
        }

        public boolean hasNextPage(GetListsMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetListsMetadataResponse nextPage(GetListsMetadataResponse previousPage) {
            if (previousPage == null) {
                return GetListsMetadataIterable.this.client.getListsMetadata(GetListsMetadataIterable.this.firstRequest);
            }
            return GetListsMetadataIterable.this.client.getListsMetadata((GetListsMetadataRequest)((Object)GetListsMetadataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

