/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsResponse;

public class GetBatchPredictionJobsIterable
implements SdkIterable<GetBatchPredictionJobsResponse> {
    private final FraudDetectorClient client;
    private final GetBatchPredictionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBatchPredictionJobsIterable(FraudDetectorClient client, GetBatchPredictionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetBatchPredictionJobsResponseFetcher();
    }

    public Iterator<GetBatchPredictionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetBatchPredictionJobsResponseFetcher
    implements SyncPageFetcher<GetBatchPredictionJobsResponse> {
        private GetBatchPredictionJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetBatchPredictionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetBatchPredictionJobsResponse nextPage(GetBatchPredictionJobsResponse previousPage) {
            if (previousPage == null) {
                return GetBatchPredictionJobsIterable.this.client.getBatchPredictionJobs(GetBatchPredictionJobsIterable.this.firstRequest);
            }
            return GetBatchPredictionJobsIterable.this.client.getBatchPredictionJobs((GetBatchPredictionJobsRequest)((Object)GetBatchPredictionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

