/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelsResponse;

public class GetModelsPublisher
implements SdkPublisher<GetModelsResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetModelsPublisher(FraudDetectorAsyncClient client, GetModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetModelsPublisher(FraudDetectorAsyncClient client, GetModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetModelsResponseFetcher
    implements AsyncPageFetcher<GetModelsResponse> {
        private GetModelsResponseFetcher() {
        }

        public boolean hasNextPage(GetModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetModelsResponse> nextPage(GetModelsResponse previousPage) {
            if (previousPage == null) {
                return GetModelsPublisher.this.client.getModels(GetModelsPublisher.this.firstRequest);
            }
            return GetModelsPublisher.this.client.getModels((GetModelsRequest)((Object)GetModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

