/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregatedVariablesImpactExplanation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregatedVariablesImpactExplanation> {
    private static final SdkField<List<String>> EVENT_VARIABLE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventVariableNames").getter(AggregatedVariablesImpactExplanation.getter(AggregatedVariablesImpactExplanation::eventVariableNames)).setter(AggregatedVariablesImpactExplanation.setter(Builder::eventVariableNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariableNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RELATIVE_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relativeImpact").getter(AggregatedVariablesImpactExplanation.getter(AggregatedVariablesImpactExplanation::relativeImpact)).setter(AggregatedVariablesImpactExplanation.setter(Builder::relativeImpact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativeImpact").build()}).build();
    private static final SdkField<Float> LOG_ODDS_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("logOddsImpact").getter(AggregatedVariablesImpactExplanation.getter(AggregatedVariablesImpactExplanation::logOddsImpact)).setter(AggregatedVariablesImpactExplanation.setter(Builder::logOddsImpact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logOddsImpact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_VARIABLE_NAMES_FIELD, RELATIVE_IMPACT_FIELD, LOG_ODDS_IMPACT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregatedVariablesImpactExplanation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> eventVariableNames;
    private final String relativeImpact;
    private final Float logOddsImpact;

    private AggregatedVariablesImpactExplanation(BuilderImpl builder) {
        this.eventVariableNames = builder.eventVariableNames;
        this.relativeImpact = builder.relativeImpact;
        this.logOddsImpact = builder.logOddsImpact;
    }

    public final boolean hasEventVariableNames() {
        return this.eventVariableNames != null && !(this.eventVariableNames instanceof SdkAutoConstructList);
    }

    public final List<String> eventVariableNames() {
        return this.eventVariableNames;
    }

    public final String relativeImpact() {
        return this.relativeImpact;
    }

    public final Float logOddsImpact() {
        return this.logOddsImpact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventVariableNames() ? this.eventVariableNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeImpact());
        hashCode = 31 * hashCode + Objects.hashCode(this.logOddsImpact());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedVariablesImpactExplanation)) {
            return false;
        }
        AggregatedVariablesImpactExplanation other = (AggregatedVariablesImpactExplanation)obj;
        return this.hasEventVariableNames() == other.hasEventVariableNames() && Objects.equals(this.eventVariableNames(), other.eventVariableNames()) && Objects.equals(this.relativeImpact(), other.relativeImpact()) && Objects.equals(this.logOddsImpact(), other.logOddsImpact());
    }

    public final String toString() {
        return ToString.builder((String)"AggregatedVariablesImpactExplanation").add("EventVariableNames", this.hasEventVariableNames() ? this.eventVariableNames() : null).add("RelativeImpact", (Object)this.relativeImpact()).add("LogOddsImpact", (Object)this.logOddsImpact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventVariableNames": {
                return Optional.ofNullable(clazz.cast(this.eventVariableNames()));
            }
            case "relativeImpact": {
                return Optional.ofNullable(clazz.cast(this.relativeImpact()));
            }
            case "logOddsImpact": {
                return Optional.ofNullable(clazz.cast(this.logOddsImpact()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventVariableNames", EVENT_VARIABLE_NAMES_FIELD);
        map.put("relativeImpact", RELATIVE_IMPACT_FIELD);
        map.put("logOddsImpact", LOG_ODDS_IMPACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregatedVariablesImpactExplanation, T> g) {
        return obj -> g.apply((AggregatedVariablesImpactExplanation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventVariableNames = DefaultSdkAutoConstructList.getInstance();
        private String relativeImpact;
        private Float logOddsImpact;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedVariablesImpactExplanation model) {
            this.eventVariableNames(model.eventVariableNames);
            this.relativeImpact(model.relativeImpact);
            this.logOddsImpact(model.logOddsImpact);
        }

        public final Collection<String> getEventVariableNames() {
            if (this.eventVariableNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventVariableNames;
        }

        public final void setEventVariableNames(Collection<String> eventVariableNames) {
            this.eventVariableNames = ListOfStringsCopier.copy(eventVariableNames);
        }

        @Override
        public final Builder eventVariableNames(Collection<String> eventVariableNames) {
            this.eventVariableNames = ListOfStringsCopier.copy(eventVariableNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventVariableNames(String ... eventVariableNames) {
            this.eventVariableNames(Arrays.asList(eventVariableNames));
            return this;
        }

        public final String getRelativeImpact() {
            return this.relativeImpact;
        }

        public final void setRelativeImpact(String relativeImpact) {
            this.relativeImpact = relativeImpact;
        }

        @Override
        public final Builder relativeImpact(String relativeImpact) {
            this.relativeImpact = relativeImpact;
            return this;
        }

        public final Float getLogOddsImpact() {
            return this.logOddsImpact;
        }

        public final void setLogOddsImpact(Float logOddsImpact) {
            this.logOddsImpact = logOddsImpact;
        }

        @Override
        public final Builder logOddsImpact(Float logOddsImpact) {
            this.logOddsImpact = logOddsImpact;
            return this;
        }

        public AggregatedVariablesImpactExplanation build() {
            return new AggregatedVariablesImpactExplanation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregatedVariablesImpactExplanation> {
        public Builder eventVariableNames(Collection<String> var1);

        public Builder eventVariableNames(String ... var1);

        public Builder relativeImpact(String var1);

        public Builder logOddsImpact(Float var1);
    }
}

