/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.DataDestination;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExplainabilityExportResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeExplainabilityExportResponse> {
    private static final SdkField<String> EXPLAINABILITY_EXPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExplainabilityExportArn").getter(DescribeExplainabilityExportResponse.getter(DescribeExplainabilityExportResponse::explainabilityExportArn)).setter(DescribeExplainabilityExportResponse.setter(Builder::explainabilityExportArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityExportArn").build()}).build();
    private static final SdkField<String> EXPLAINABILITY_EXPORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExplainabilityExportName").getter(DescribeExplainabilityExportResponse.getter(DescribeExplainabilityExportResponse::explainabilityExportName)).setter(DescribeExplainabilityExportResponse.setter(Builder::explainabilityExportName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityExportName").build()}).build();
    private static final SdkField<String> EXPLAINABILITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExplainabilityArn").getter(DescribeExplainabilityExportResponse.getter(DescribeExplainabilityExportResponse::explainabilityArn)).setter(DescribeExplainabilityExportResponse.setter(Builder::explainabilityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityArn").build()}).build();
    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(DescribeExplainabilityExportResponse.getter(DescribeExplainabilityExportResponse::destination)).setter(DescribeExplainabilityExportResponse.setter(Builder::destination)).constructor(DataDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribeExplainabilityExportResponse.getter(DescribeExplainabilityExportResponse::message)).setter(DescribeExplainabilityExportResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeExplainabilityExportResponse.getter(DescribeExplainabilityExportResponse::status)).setter(DescribeExplainabilityExportResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeExplainabilityExportResponse.getter(DescribeExplainabilityExportResponse::creationTime)).setter(DescribeExplainabilityExportResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeExplainabilityExportResponse.getter(DescribeExplainabilityExportResponse::lastModificationTime)).setter(DescribeExplainabilityExportResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(DescribeExplainabilityExportResponse.getter(DescribeExplainabilityExportResponse::format)).setter(DescribeExplainabilityExportResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_EXPORT_ARN_FIELD, EXPLAINABILITY_EXPORT_NAME_FIELD, EXPLAINABILITY_ARN_FIELD, DESTINATION_FIELD, MESSAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeExplainabilityExportResponse.memberNameToFieldInitializer();
    private final String explainabilityExportArn;
    private final String explainabilityExportName;
    private final String explainabilityArn;
    private final DataDestination destination;
    private final String message;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final String format;

    private DescribeExplainabilityExportResponse(BuilderImpl builder) {
        super(builder);
        this.explainabilityExportArn = builder.explainabilityExportArn;
        this.explainabilityExportName = builder.explainabilityExportName;
        this.explainabilityArn = builder.explainabilityArn;
        this.destination = builder.destination;
        this.message = builder.message;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.format = builder.format;
    }

    public final String explainabilityExportArn() {
        return this.explainabilityExportArn;
    }

    public final String explainabilityExportName() {
        return this.explainabilityExportName;
    }

    public final String explainabilityArn() {
        return this.explainabilityArn;
    }

    public final DataDestination destination() {
        return this.destination;
    }

    public final String message() {
        return this.message;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final String format() {
        return this.format;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityExportArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityExportName());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExplainabilityExportResponse)) {
            return false;
        }
        DescribeExplainabilityExportResponse other = (DescribeExplainabilityExportResponse)((Object)obj);
        return Objects.equals(this.explainabilityExportArn(), other.explainabilityExportArn()) && Objects.equals(this.explainabilityExportName(), other.explainabilityExportName()) && Objects.equals(this.explainabilityArn(), other.explainabilityArn()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.format(), other.format());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExplainabilityExportResponse").add("ExplainabilityExportArn", (Object)this.explainabilityExportArn()).add("ExplainabilityExportName", (Object)this.explainabilityExportName()).add("ExplainabilityArn", (Object)this.explainabilityArn()).add("Destination", (Object)this.destination()).add("Message", (Object)this.message()).add("Status", (Object)this.status()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("Format", (Object)this.format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExplainabilityExportArn": {
                return Optional.ofNullable(clazz.cast(this.explainabilityExportArn()));
            }
            case "ExplainabilityExportName": {
                return Optional.ofNullable(clazz.cast(this.explainabilityExportName()));
            }
            case "ExplainabilityArn": {
                return Optional.ofNullable(clazz.cast(this.explainabilityArn()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExplainabilityExportArn", EXPLAINABILITY_EXPORT_ARN_FIELD);
        map.put("ExplainabilityExportName", EXPLAINABILITY_EXPORT_NAME_FIELD);
        map.put("ExplainabilityArn", EXPLAINABILITY_ARN_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("Format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExplainabilityExportResponse, T> g) {
        return obj -> g.apply((DescribeExplainabilityExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String explainabilityExportArn;
        private String explainabilityExportName;
        private String explainabilityArn;
        private DataDestination destination;
        private String message;
        private String status;
        private Instant creationTime;
        private Instant lastModificationTime;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExplainabilityExportResponse model) {
            super(model);
            this.explainabilityExportArn(model.explainabilityExportArn);
            this.explainabilityExportName(model.explainabilityExportName);
            this.explainabilityArn(model.explainabilityArn);
            this.destination(model.destination);
            this.message(model.message);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.format(model.format);
        }

        public final String getExplainabilityExportArn() {
            return this.explainabilityExportArn;
        }

        public final void setExplainabilityExportArn(String explainabilityExportArn) {
            this.explainabilityExportArn = explainabilityExportArn;
        }

        @Override
        public final Builder explainabilityExportArn(String explainabilityExportArn) {
            this.explainabilityExportArn = explainabilityExportArn;
            return this;
        }

        public final String getExplainabilityExportName() {
            return this.explainabilityExportName;
        }

        public final void setExplainabilityExportName(String explainabilityExportName) {
            this.explainabilityExportName = explainabilityExportName;
        }

        @Override
        public final Builder explainabilityExportName(String explainabilityExportName) {
            this.explainabilityExportName = explainabilityExportName;
            return this;
        }

        public final String getExplainabilityArn() {
            return this.explainabilityArn;
        }

        public final void setExplainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
        }

        @Override
        public final Builder explainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
            return this;
        }

        public final DataDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public DescribeExplainabilityExportResponse build() {
            return new DescribeExplainabilityExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExplainabilityExportResponse> {
        public Builder explainabilityExportArn(String var1);

        public Builder explainabilityExportName(String var1);

        public Builder explainabilityArn(String var1);

        public Builder destination(DataDestination var1);

        default public Builder destination(Consumer<DataDestination.Builder> destination) {
            return this.destination((DataDestination)((DataDestination.Builder)DataDestination.builder().applyMutation(destination)).build());
        }

        public Builder message(String var1);

        public Builder status(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder format(String var1);
    }
}

