/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.PredictorSummary;
import software.amazon.awssdk.services.forecast.model.PredictorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPredictorsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListPredictorsResponse> {
    private static final SdkField<List<PredictorSummary>> PREDICTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Predictors").getter(ListPredictorsResponse.getter(ListPredictorsResponse::predictors)).setter(ListPredictorsResponse.setter(Builder::predictors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predictors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPredictorsResponse.getter(ListPredictorsResponse::nextToken)).setter(ListPredictorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPredictorsResponse.memberNameToFieldInitializer();
    private final List<PredictorSummary> predictors;
    private final String nextToken;

    private ListPredictorsResponse(BuilderImpl builder) {
        super(builder);
        this.predictors = builder.predictors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPredictors() {
        return this.predictors != null && !(this.predictors instanceof SdkAutoConstructList);
    }

    public final List<PredictorSummary> predictors() {
        return this.predictors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredictors() ? this.predictors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPredictorsResponse)) {
            return false;
        }
        ListPredictorsResponse other = (ListPredictorsResponse)((Object)obj);
        return this.hasPredictors() == other.hasPredictors() && Objects.equals(this.predictors(), other.predictors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPredictorsResponse").add("Predictors", this.hasPredictors() ? this.predictors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Predictors": {
                return Optional.ofNullable(clazz.cast(this.predictors()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Predictors", PREDICTORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPredictorsResponse, T> g) {
        return obj -> g.apply((ListPredictorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<PredictorSummary> predictors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPredictorsResponse model) {
            super(model);
            this.predictors(model.predictors);
            this.nextToken(model.nextToken);
        }

        public final List<PredictorSummary.Builder> getPredictors() {
            List<PredictorSummary.Builder> result = PredictorsCopier.copyToBuilder(this.predictors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredictors(Collection<PredictorSummary.BuilderImpl> predictors) {
            this.predictors = PredictorsCopier.copyFromBuilder(predictors);
        }

        @Override
        public final Builder predictors(Collection<PredictorSummary> predictors) {
            this.predictors = PredictorsCopier.copy(predictors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictors(PredictorSummary ... predictors) {
            this.predictors(Arrays.asList(predictors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictors(Consumer<PredictorSummary.Builder> ... predictors) {
            this.predictors(Stream.of(predictors).map(c -> (PredictorSummary)((PredictorSummary.Builder)PredictorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPredictorsResponse build() {
            return new ListPredictorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPredictorsResponse> {
        public Builder predictors(Collection<PredictorSummary> var1);

        public Builder predictors(PredictorSummary ... var1);

        public Builder predictors(Consumer<PredictorSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

