/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesRequest;
import software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesResponse;
import software.amazon.awssdk.services.forecast.model.WhatIfAnalysisSummary;

public class ListWhatIfAnalysesIterable
implements SdkIterable<ListWhatIfAnalysesResponse> {
    private final ForecastClient client;
    private final ListWhatIfAnalysesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWhatIfAnalysesIterable(ForecastClient client, ListWhatIfAnalysesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWhatIfAnalysesResponseFetcher();
    }

    public Iterator<ListWhatIfAnalysesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WhatIfAnalysisSummary> whatIfAnalyses() {
        Function<ListWhatIfAnalysesResponse, Iterator> getIterator = response -> {
            if (response != null && response.whatIfAnalyses() != null) {
                return response.whatIfAnalyses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWhatIfAnalysesResponseFetcher
    implements SyncPageFetcher<ListWhatIfAnalysesResponse> {
        private ListWhatIfAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(ListWhatIfAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWhatIfAnalysesResponse nextPage(ListWhatIfAnalysesResponse previousPage) {
            if (previousPage == null) {
                return ListWhatIfAnalysesIterable.this.client.listWhatIfAnalyses(ListWhatIfAnalysesIterable.this.firstRequest);
            }
            return ListWhatIfAnalysesIterable.this.client.listWhatIfAnalyses((ListWhatIfAnalysesRequest)((Object)ListWhatIfAnalysesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

