/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary;
import software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse;

public class ListForecastExportJobsPublisher
implements SdkPublisher<ListForecastExportJobsResponse> {
    private final ForecastAsyncClient client;
    private final ListForecastExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListForecastExportJobsPublisher(ForecastAsyncClient client, ListForecastExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListForecastExportJobsPublisher(ForecastAsyncClient client, ListForecastExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListForecastExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListForecastExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ForecastExportJobSummary> forecastExportJobs() {
        Function<ListForecastExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.forecastExportJobs() != null) {
                return response.forecastExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListForecastExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListForecastExportJobsResponseFetcher
    implements AsyncPageFetcher<ListForecastExportJobsResponse> {
        private ListForecastExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListForecastExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListForecastExportJobsResponse> nextPage(ListForecastExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListForecastExportJobsPublisher.this.client.listForecastExportJobs(ListForecastExportJobsPublisher.this.firstRequest);
            }
            return ListForecastExportJobsPublisher.this.client.listForecastExportJobs((ListForecastExportJobsRequest)((Object)ListForecastExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

