/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDatasetImportJobsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListDatasetImportJobsResponse.Builder, ListDatasetImportJobsResponse> {
    private static final SdkField<List<DatasetImportJobSummary>> DATASET_IMPORT_JOBS_FIELD = SdkField
            .<List<DatasetImportJobSummary>> builder(MarshallingType.LIST)
            .memberName("DatasetImportJobs")
            .getter(getter(ListDatasetImportJobsResponse::datasetImportJobs))
            .setter(setter(Builder::datasetImportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetImportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetImportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDatasetImportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DatasetImportJobSummary> datasetImportJobs;

    private final String nextToken;

    private ListDatasetImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobs = builder.datasetImportJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasetImportJobs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasetImportJobs() {
        return datasetImportJobs != null && !(datasetImportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize each dataset import job's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasetImportJobs} method.
     * </p>
     * 
     * @return An array of objects that summarize each dataset import job's properties.
     */
    public final List<DatasetImportJobSummary> datasetImportJobs() {
        return datasetImportJobs;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the
     * token in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
     *         use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasetImportJobs() ? datasetImportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetImportJobsResponse)) {
            return false;
        }
        ListDatasetImportJobsResponse other = (ListDatasetImportJobsResponse) obj;
        return hasDatasetImportJobs() == other.hasDatasetImportJobs()
                && Objects.equals(datasetImportJobs(), other.datasetImportJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDatasetImportJobsResponse")
                .add("DatasetImportJobs", hasDatasetImportJobs() ? datasetImportJobs() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetImportJobs":
            return Optional.ofNullable(clazz.cast(datasetImportJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetImportJobsResponse, T> g) {
        return obj -> g.apply((ListDatasetImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDatasetImportJobsResponse> {
        /**
         * <p>
         * An array of objects that summarize each dataset import job's properties.
         * </p>
         * 
         * @param datasetImportJobs
         *        An array of objects that summarize each dataset import job's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobs(Collection<DatasetImportJobSummary> datasetImportJobs);

        /**
         * <p>
         * An array of objects that summarize each dataset import job's properties.
         * </p>
         * 
         * @param datasetImportJobs
         *        An array of objects that summarize each dataset import job's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobs(DatasetImportJobSummary... datasetImportJobs);

        /**
         * <p>
         * An array of objects that summarize each dataset import job's properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetImportJobSummary>.Builder} avoiding
         * the need to create one manually via {@link List<DatasetImportJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetImportJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetImportJobs(List<DatasetImportJobSummary>)}.
         * 
         * @param datasetImportJobs
         *        a consumer that will call methods on {@link List<DatasetImportJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetImportJobs(List<DatasetImportJobSummary>)
         */
        Builder datasetImportJobs(Consumer<DatasetImportJobSummary.Builder>... datasetImportJobs);

        /**
         * <p>
         * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use
         * the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
         *        use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<DatasetImportJobSummary> datasetImportJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetImportJobsResponse model) {
            super(model);
            datasetImportJobs(model.datasetImportJobs);
            nextToken(model.nextToken);
        }

        public final List<DatasetImportJobSummary.Builder> getDatasetImportJobs() {
            List<DatasetImportJobSummary.Builder> result = DatasetImportJobsCopier.copyToBuilder(this.datasetImportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetImportJobs(Collection<DatasetImportJobSummary.BuilderImpl> datasetImportJobs) {
            this.datasetImportJobs = DatasetImportJobsCopier.copyFromBuilder(datasetImportJobs);
        }

        @Override
        @Transient
        public final Builder datasetImportJobs(Collection<DatasetImportJobSummary> datasetImportJobs) {
            this.datasetImportJobs = DatasetImportJobsCopier.copy(datasetImportJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder datasetImportJobs(DatasetImportJobSummary... datasetImportJobs) {
            datasetImportJobs(Arrays.asList(datasetImportJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder datasetImportJobs(Consumer<DatasetImportJobSummary.Builder>... datasetImportJobs) {
            datasetImportJobs(Stream.of(datasetImportJobs).map(c -> DatasetImportJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasetImportJobsResponse build() {
            return new ListDatasetImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
