/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeForecastResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeForecastResponse.Builder, DescribeForecastResponse> {
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastArn").getter(getter(DescribeForecastResponse::forecastArn)).setter(setter(Builder::forecastArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()).build();

    private static final SdkField<String> FORECAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastName").getter(getter(DescribeForecastResponse::forecastName))
            .setter(setter(Builder::forecastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastName").build()).build();

    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ForecastTypes")
            .getter(getter(DescribeForecastResponse::forecastTypes))
            .setter(setter(Builder::forecastTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorArn").getter(getter(DescribeForecastResponse::predictorArn))
            .setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetGroupArn").getter(getter(DescribeForecastResponse::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()).build();

    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeRemainingInMinutes")
            .getter(getter(DescribeForecastResponse::estimatedTimeRemainingInMinutes))
            .setter(setter(Builder::estimatedTimeRemainingInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeForecastResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeForecastResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeForecastResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeForecastResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_ARN_FIELD,
            FORECAST_NAME_FIELD, FORECAST_TYPES_FIELD, PREDICTOR_ARN_FIELD, DATASET_GROUP_ARN_FIELD,
            ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD));

    private final String forecastArn;

    private final String forecastName;

    private final List<String> forecastTypes;

    private final String predictorArn;

    private final String datasetGroupArn;

    private final Long estimatedTimeRemainingInMinutes;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private DescribeForecastResponse(BuilderImpl builder) {
        super(builder);
        this.forecastArn = builder.forecastArn;
        this.forecastName = builder.forecastName;
        this.forecastTypes = builder.forecastTypes;
        this.predictorArn = builder.predictorArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The forecast ARN as specified in the request.
     * </p>
     * 
     * @return The forecast ARN as specified in the request.
     */
    public final String forecastArn() {
        return forecastArn;
    }

    /**
     * <p>
     * The name of the forecast.
     * </p>
     * 
     * @return The name of the forecast.
     */
    public final String forecastName() {
        return forecastName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastTypes() {
        return forecastTypes != null && !(forecastTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The quantiles at which probabilistic forecasts were generated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastTypes} method.
     * </p>
     * 
     * @return The quantiles at which probabilistic forecasts were generated.
     */
    public final List<String> forecastTypes() {
        return forecastTypes;
    }

    /**
     * <p>
     * The ARN of the predictor used to generate the forecast.
     * </p>
     * 
     * @return The ARN of the predictor used to generate the forecast.
     */
    public final String predictorArn() {
        return predictorArn;
    }

    /**
     * <p>
     * The ARN of the dataset group that provided the data used to train the predictor.
     * </p>
     * 
     * @return The ARN of the dataset group that provided the data used to train the predictor.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The estimated time remaining in minutes for the forecast job to complete.
     * </p>
     * 
     * @return The estimated time remaining in minutes for the forecast job to complete.
     */
    public final Long estimatedTimeRemainingInMinutes() {
        return estimatedTimeRemainingInMinutes;
    }

    /**
     * <p>
     * The status of the forecast. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.
     * </p>
     * </note>
     * 
     * @return The status of the forecast. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the
     *         forecast.
     *         </p>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the forecast creation task was created.
     * </p>
     * 
     * @return When the forecast creation task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(forecastName());
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastTypes() ? forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeForecastResponse)) {
            return false;
        }
        DescribeForecastResponse other = (DescribeForecastResponse) obj;
        return Objects.equals(forecastArn(), other.forecastArn()) && Objects.equals(forecastName(), other.forecastName())
                && hasForecastTypes() == other.hasForecastTypes() && Objects.equals(forecastTypes(), other.forecastTypes())
                && Objects.equals(predictorArn(), other.predictorArn())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes())
                && Objects.equals(status(), other.status()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeForecastResponse").add("ForecastArn", forecastArn()).add("ForecastName", forecastName())
                .add("ForecastTypes", hasForecastTypes() ? forecastTypes() : null).add("PredictorArn", predictorArn())
                .add("DatasetGroupArn", datasetGroupArn())
                .add("EstimatedTimeRemainingInMinutes", estimatedTimeRemainingInMinutes()).add("Status", status())
                .add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastArn":
            return Optional.ofNullable(clazz.cast(forecastArn()));
        case "ForecastName":
            return Optional.ofNullable(clazz.cast(forecastName()));
        case "ForecastTypes":
            return Optional.ofNullable(clazz.cast(forecastTypes()));
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        case "DatasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "EstimatedTimeRemainingInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedTimeRemainingInMinutes()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeForecastResponse, T> g) {
        return obj -> g.apply((DescribeForecastResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeForecastResponse> {
        /**
         * <p>
         * The forecast ARN as specified in the request.
         * </p>
         * 
         * @param forecastArn
         *        The forecast ARN as specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastArn(String forecastArn);

        /**
         * <p>
         * The name of the forecast.
         * </p>
         * 
         * @param forecastName
         *        The name of the forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastName(String forecastName);

        /**
         * <p>
         * The quantiles at which probabilistic forecasts were generated.
         * </p>
         * 
         * @param forecastTypes
         *        The quantiles at which probabilistic forecasts were generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(Collection<String> forecastTypes);

        /**
         * <p>
         * The quantiles at which probabilistic forecasts were generated.
         * </p>
         * 
         * @param forecastTypes
         *        The quantiles at which probabilistic forecasts were generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(String... forecastTypes);

        /**
         * <p>
         * The ARN of the predictor used to generate the forecast.
         * </p>
         * 
         * @param predictorArn
         *        The ARN of the predictor used to generate the forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);

        /**
         * <p>
         * The ARN of the dataset group that provided the data used to train the predictor.
         * </p>
         * 
         * @param datasetGroupArn
         *        The ARN of the dataset group that provided the data used to train the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The estimated time remaining in minutes for the forecast job to complete.
         * </p>
         * 
         * @param estimatedTimeRemainingInMinutes
         *        The estimated time remaining in minutes for the forecast job to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes);

        /**
         * <p>
         * The status of the forecast. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the
         * forecast.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the forecast. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the
         *        forecast.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the forecast creation task was created.
         * </p>
         * 
         * @param creationTime
         *        When the forecast creation task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String forecastArn;

        private String forecastName;

        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();

        private String predictorArn;

        private String datasetGroupArn;

        private Long estimatedTimeRemainingInMinutes;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeForecastResponse model) {
            super(model);
            forecastArn(model.forecastArn);
            forecastName(model.forecastName);
            forecastTypes(model.forecastTypes);
            predictorArn(model.predictorArn);
            datasetGroupArn(model.datasetGroupArn);
            estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getForecastArn() {
            return forecastArn;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        @Override
        @Transient
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final String getForecastName() {
            return forecastName;
        }

        public final void setForecastName(String forecastName) {
            this.forecastName = forecastName;
        }

        @Override
        @Transient
        public final Builder forecastName(String forecastName) {
            this.forecastName = forecastName;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        @Transient
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder forecastTypes(String... forecastTypes) {
            forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        @Transient
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        @Transient
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        @Transient
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        @Transient
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public DescribeForecastResponse build() {
            return new DescribeForecastResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
