/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.services.fms.model.PolicySummary;
import software.amazon.awssdk.services.fms.model.PolicySummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPoliciesResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, ListPoliciesResponse> {
    private static final SdkField<List<PolicySummary>> POLICY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyList").getter(ListPoliciesResponse.getter(ListPoliciesResponse::policyList)).setter(ListPoliciesResponse.setter(Builder::policyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPoliciesResponse.getter(ListPoliciesResponse::nextToken)).setter(ListPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPoliciesResponse.memberNameToFieldInitializer();
    private final List<PolicySummary> policyList;
    private final String nextToken;

    private ListPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policyList = builder.policyList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPolicyList() {
        return this.policyList != null && !(this.policyList instanceof SdkAutoConstructList);
    }

    public final List<PolicySummary> policyList() {
        return this.policyList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyList() ? this.policyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesResponse)) {
            return false;
        }
        ListPoliciesResponse other = (ListPoliciesResponse)((Object)obj);
        return this.hasPolicyList() == other.hasPolicyList() && Objects.equals(this.policyList(), other.policyList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPoliciesResponse").add("PolicyList", this.hasPolicyList() ? this.policyList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyList": {
                return Optional.ofNullable(clazz.cast(this.policyList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyList", POLICY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesResponse, T> g) {
        return obj -> g.apply((ListPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private List<PolicySummary> policyList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesResponse model) {
            super(model);
            this.policyList(model.policyList);
            this.nextToken(model.nextToken);
        }

        public final List<PolicySummary.Builder> getPolicyList() {
            List<PolicySummary.Builder> result = PolicySummaryListCopier.copyToBuilder(this.policyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyList(Collection<PolicySummary.BuilderImpl> policyList) {
            this.policyList = PolicySummaryListCopier.copyFromBuilder(policyList);
        }

        @Override
        public final Builder policyList(Collection<PolicySummary> policyList) {
            this.policyList = PolicySummaryListCopier.copy(policyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyList(PolicySummary ... policyList) {
            this.policyList(Arrays.asList(policyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyList(Consumer<PolicySummary.Builder> ... policyList) {
            this.policyList(Stream.of(policyList).map(c -> (PolicySummary)((PolicySummary.Builder)PolicySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPoliciesResponse build() {
            return new ListPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPoliciesResponse> {
        public Builder policyList(Collection<PolicySummary> var1);

        public Builder policyList(PolicySummary ... var1);

        public Builder policyList(Consumer<PolicySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

