/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.AppsListDataSummary;
import software.amazon.awssdk.services.fms.model.AppsListsDataCopier;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppsListsResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, ListAppsListsResponse> {
    private static final SdkField<List<AppsListDataSummary>> APPS_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppsLists").getter(ListAppsListsResponse.getter(ListAppsListsResponse::appsLists)).setter(ListAppsListsResponse.setter(Builder::appsLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppsListDataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAppsListsResponse.getter(ListAppsListsResponse::nextToken)).setter(ListAppsListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_LISTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAppsListsResponse.memberNameToFieldInitializer();
    private final List<AppsListDataSummary> appsLists;
    private final String nextToken;

    private ListAppsListsResponse(BuilderImpl builder) {
        super(builder);
        this.appsLists = builder.appsLists;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAppsLists() {
        return this.appsLists != null && !(this.appsLists instanceof SdkAutoConstructList);
    }

    public final List<AppsListDataSummary> appsLists() {
        return this.appsLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppsLists() ? this.appsLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsListsResponse)) {
            return false;
        }
        ListAppsListsResponse other = (ListAppsListsResponse)((Object)obj);
        return this.hasAppsLists() == other.hasAppsLists() && Objects.equals(this.appsLists(), other.appsLists()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppsListsResponse").add("AppsLists", this.hasAppsLists() ? this.appsLists() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppsLists": {
                return Optional.ofNullable(clazz.cast(this.appsLists()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppsLists", APPS_LISTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppsListsResponse, T> g) {
        return obj -> g.apply((ListAppsListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private List<AppsListDataSummary> appsLists = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsListsResponse model) {
            super(model);
            this.appsLists(model.appsLists);
            this.nextToken(model.nextToken);
        }

        public final List<AppsListDataSummary.Builder> getAppsLists() {
            List<AppsListDataSummary.Builder> result = AppsListsDataCopier.copyToBuilder(this.appsLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppsLists(Collection<AppsListDataSummary.BuilderImpl> appsLists) {
            this.appsLists = AppsListsDataCopier.copyFromBuilder(appsLists);
        }

        @Override
        public final Builder appsLists(Collection<AppsListDataSummary> appsLists) {
            this.appsLists = AppsListsDataCopier.copy(appsLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsLists(AppsListDataSummary ... appsLists) {
            this.appsLists(Arrays.asList(appsLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsLists(Consumer<AppsListDataSummary.Builder> ... appsLists) {
            this.appsLists(Stream.of(appsLists).map(c -> (AppsListDataSummary)((AppsListDataSummary.Builder)AppsListDataSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppsListsResponse build() {
            return new ListAppsListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppsListsResponse> {
        public Builder appsLists(Collection<AppsListDataSummary> var1);

        public Builder appsLists(AppsListDataSummary ... var1);

        public Builder appsLists(Consumer<AppsListDataSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

