/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fms.model.App;
import software.amazon.awssdk.services.fms.model.AppsListCopier;
import software.amazon.awssdk.services.fms.model.PreviousAppsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppsListData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppsListData> {
    private static final SdkField<String> LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListId").getter(AppsListData.getter(AppsListData::listId)).setter(AppsListData.setter(Builder::listId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()}).build();
    private static final SdkField<String> LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListName").getter(AppsListData.getter(AppsListData::listName)).setter(AppsListData.setter(Builder::listName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListName").build()}).build();
    private static final SdkField<String> LIST_UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListUpdateToken").getter(AppsListData.getter(AppsListData::listUpdateToken)).setter(AppsListData.setter(Builder::listUpdateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListUpdateToken").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(AppsListData.getter(AppsListData::createTime)).setter(AppsListData.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(AppsListData.getter(AppsListData::lastUpdateTime)).setter(AppsListData.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final SdkField<List<App>> APPS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppsList").getter(AppsListData.getter(AppsListData::appsList)).setter(AppsListData.setter(Builder::appsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(App::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<App>>> PREVIOUS_APPS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PreviousAppsList").getter(AppsListData.getter(AppsListData::previousAppsList)).setter(AppsListData.setter(Builder::previousAppsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousAppsList").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(App::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ID_FIELD, LIST_NAME_FIELD, LIST_UPDATE_TOKEN_FIELD, CREATE_TIME_FIELD, LAST_UPDATE_TIME_FIELD, APPS_LIST_FIELD, PREVIOUS_APPS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppsListData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String listId;
    private final String listName;
    private final String listUpdateToken;
    private final Instant createTime;
    private final Instant lastUpdateTime;
    private final List<App> appsList;
    private final Map<String, List<App>> previousAppsList;

    private AppsListData(BuilderImpl builder) {
        this.listId = builder.listId;
        this.listName = builder.listName;
        this.listUpdateToken = builder.listUpdateToken;
        this.createTime = builder.createTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.appsList = builder.appsList;
        this.previousAppsList = builder.previousAppsList;
    }

    public final String listId() {
        return this.listId;
    }

    public final String listName() {
        return this.listName;
    }

    public final String listUpdateToken() {
        return this.listUpdateToken;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final boolean hasAppsList() {
        return this.appsList != null && !(this.appsList instanceof SdkAutoConstructList);
    }

    public final List<App> appsList() {
        return this.appsList;
    }

    public final boolean hasPreviousAppsList() {
        return this.previousAppsList != null && !(this.previousAppsList instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<App>> previousAppsList() {
        return this.previousAppsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listId());
        hashCode = 31 * hashCode + Objects.hashCode(this.listName());
        hashCode = 31 * hashCode + Objects.hashCode(this.listUpdateToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppsList() ? this.appsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreviousAppsList() ? this.previousAppsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppsListData)) {
            return false;
        }
        AppsListData other = (AppsListData)obj;
        return Objects.equals(this.listId(), other.listId()) && Objects.equals(this.listName(), other.listName()) && Objects.equals(this.listUpdateToken(), other.listUpdateToken()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && this.hasAppsList() == other.hasAppsList() && Objects.equals(this.appsList(), other.appsList()) && this.hasPreviousAppsList() == other.hasPreviousAppsList() && Objects.equals(this.previousAppsList(), other.previousAppsList());
    }

    public final String toString() {
        return ToString.builder((String)"AppsListData").add("ListId", (Object)this.listId()).add("ListName", (Object)this.listName()).add("ListUpdateToken", (Object)this.listUpdateToken()).add("CreateTime", (Object)this.createTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("AppsList", this.hasAppsList() ? this.appsList() : null).add("PreviousAppsList", this.hasPreviousAppsList() ? this.previousAppsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListId": {
                return Optional.ofNullable(clazz.cast(this.listId()));
            }
            case "ListName": {
                return Optional.ofNullable(clazz.cast(this.listName()));
            }
            case "ListUpdateToken": {
                return Optional.ofNullable(clazz.cast(this.listUpdateToken()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "AppsList": {
                return Optional.ofNullable(clazz.cast(this.appsList()));
            }
            case "PreviousAppsList": {
                return Optional.ofNullable(clazz.cast(this.previousAppsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ListId", LIST_ID_FIELD);
        map.put("ListName", LIST_NAME_FIELD);
        map.put("ListUpdateToken", LIST_UPDATE_TOKEN_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("AppsList", APPS_LIST_FIELD);
        map.put("PreviousAppsList", PREVIOUS_APPS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppsListData, T> g) {
        return obj -> g.apply((AppsListData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String listId;
        private String listName;
        private String listUpdateToken;
        private Instant createTime;
        private Instant lastUpdateTime;
        private List<App> appsList = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<App>> previousAppsList = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppsListData model) {
            this.listId(model.listId);
            this.listName(model.listName);
            this.listUpdateToken(model.listUpdateToken);
            this.createTime(model.createTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.appsList(model.appsList);
            this.previousAppsList(model.previousAppsList);
        }

        public final String getListId() {
            return this.listId;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final String getListName() {
            return this.listName;
        }

        public final void setListName(String listName) {
            this.listName = listName;
        }

        @Override
        public final Builder listName(String listName) {
            this.listName = listName;
            return this;
        }

        public final String getListUpdateToken() {
            return this.listUpdateToken;
        }

        public final void setListUpdateToken(String listUpdateToken) {
            this.listUpdateToken = listUpdateToken;
        }

        @Override
        public final Builder listUpdateToken(String listUpdateToken) {
            this.listUpdateToken = listUpdateToken;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final List<App.Builder> getAppsList() {
            List<App.Builder> result = AppsListCopier.copyToBuilder(this.appsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppsList(Collection<App.BuilderImpl> appsList) {
            this.appsList = AppsListCopier.copyFromBuilder(appsList);
        }

        @Override
        public final Builder appsList(Collection<App> appsList) {
            this.appsList = AppsListCopier.copy(appsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsList(App ... appsList) {
            this.appsList(Arrays.asList(appsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsList(Consumer<App.Builder> ... appsList) {
            this.appsList(Stream.of(appsList).map(c -> (App)((App.Builder)App.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, List<App.Builder>> getPreviousAppsList() {
            Map<String, List<App.Builder>> result = PreviousAppsListCopier.copyToBuilder(this.previousAppsList);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPreviousAppsList(Map<String, ? extends Collection<App.BuilderImpl>> previousAppsList) {
            this.previousAppsList = PreviousAppsListCopier.copyFromBuilder(previousAppsList);
        }

        @Override
        public final Builder previousAppsList(Map<String, ? extends Collection<App>> previousAppsList) {
            this.previousAppsList = PreviousAppsListCopier.copy(previousAppsList);
            return this;
        }

        public AppsListData build() {
            return new AppsListData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppsListData> {
        public Builder listId(String var1);

        public Builder listName(String var1);

        public Builder listUpdateToken(String var1);

        public Builder createTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder appsList(Collection<App> var1);

        public Builder appsList(App ... var1);

        public Builder appsList(Consumer<App.Builder> ... var1);

        public Builder previousAppsList(Map<String, ? extends Collection<App>> var1);
    }
}

