/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsClient;
import software.amazon.awssdk.services.fms.internal.UserAgentUtils;
import software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest;
import software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse;
import software.amazon.awssdk.services.fms.model.ProtocolsListDataSummary;

public class ListProtocolsListsIterable
implements SdkIterable<ListProtocolsListsResponse> {
    private final FmsClient client;
    private final ListProtocolsListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProtocolsListsIterable(FmsClient client, ListProtocolsListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProtocolsListsResponseFetcher();
    }

    public Iterator<ListProtocolsListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProtocolsListDataSummary> protocolsLists() {
        Function<ListProtocolsListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.protocolsLists() != null) {
                return response.protocolsLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProtocolsListsResponseFetcher
    implements SyncPageFetcher<ListProtocolsListsResponse> {
        private ListProtocolsListsResponseFetcher() {
        }

        public boolean hasNextPage(ListProtocolsListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProtocolsListsResponse nextPage(ListProtocolsListsResponse previousPage) {
            if (previousPage == null) {
                return ListProtocolsListsIterable.this.client.listProtocolsLists(ListProtocolsListsIterable.this.firstRequest);
            }
            return ListProtocolsListsIterable.this.client.listProtocolsLists((ListProtocolsListsRequest)((Object)ListProtocolsListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

